/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.MvcProjectStructure;
import org.jetbrains.plugins.groovy.mvc.MvcRunConfiguration;

public abstract class MvcFramework {
    protected static final ExtensionPointName<MvcFramework> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.mvc.framework");
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.mvc.MvcFramework");
    public static final Key<Boolean> CREATE_APP_STRUCTURE = Key.create((String)"CREATE_MVC_APP_STRUCTURE");
    public static final Key<Boolean> UPGRADE = Key.create((String)"UPGRADE");
    public static final String GROOVY_STARTER_CONF = "/conf/groovy-starter.conf";
    public static final String XMX_JVM_PARAMETER = "-Xmx";

    public abstract boolean hasSupport(Module var1);

    public boolean isAuxModule(Module module) {
        return this.isCommonPluginsModule(module) || this.isGlobalPluginModule(module);
    }

    public GroovyLibraryDescription createLibraryDescription() {
        return new GroovyLibraryDescription(this.getSdkHomePropertyName(), this.getLibraryKind(), this.getDisplayName());
    }

    public boolean hasFrameworkJar(Module module) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(this.getSomeFrameworkClass(), scope) != null;
    }

    public boolean isCommonPluginsModule(Module module) {
        return module.getName().endsWith(this.getCommonPluginSuffix());
    }

    public List<Module> reorderModulesForMvcView(List<Module> modules) {
        return modules;
    }

    public abstract String getApplicationDirectoryName();

    public void syncSdkAndLibrariesInPluginsModule(Module module) {
        Module pluginsModule = this.findCommonPluginsModule(module);
        if (pluginsModule != null) {
            MvcModuleStructureUtil.syncAuxModuleSdk(module, pluginsModule, this);
        }
    }

    public boolean isInteractiveConsoleSupported(Module module) {
        return false;
    }

    public void runInteractiveConsole(Module module) {
        throw new UnsupportedOperationException();
    }

    public abstract void upgradeFramework(Module var1);

    public void createApplicationIfNeeded(final Module module) {
        if (this.findAppRoot(module) == null && module.getUserData(CREATE_APP_STRUCTURE) == Boolean.TRUE) {
            while (ModuleRootManager.getInstance((Module)module).getSdk() == null) {
                if (Messages.showYesNoDialog((Project)module.getProject(), (String)("Cannot generate " + this.getDisplayName() + " project structure because JDK is not specified for module \"" + module.getName() + "\".\n" + this.getDisplayName() + " project will not be created if you don't specify JDK.\nDo you want to specify JDK?"), (String)"Error", (Icon)Messages.getErrorIcon()) == 1) {
                    return;
                }
                ProjectSettingsService.getInstance((Project)module.getProject()).showModuleConfigurationDialog(module.getName(), ClasspathEditor.NAME);
            }
            module.putUserData(CREATE_APP_STRUCTURE, null);
            GeneralCommandLine commandLine = this.getCreationCommandLine(module);
            if (commandLine == null) {
                return;
            }
            MvcConsole.executeProcess(module, commandLine, new Runnable(){

                @Override
                public void run() {
                    VirtualFile root = MvcFramework.this.findAppRoot(module);
                    if (root == null) {
                        return;
                    }
                    PsiDirectory psiDir = PsiManager.getInstance((Project)module.getProject()).findDirectory(root);
                    IdeView ide = (IdeView)LangDataKeys.IDE_VIEW.getData(DataManager.getInstance().getDataContext());
                    if (ide != null) {
                        ide.selectElement((PsiElement)psiDir);
                    }
                }
            }, true, new String[0]);
        }
    }

    protected GeneralCommandLine getCreationCommandLine(Module module) {
        String message = "Create default " + this.getDisplayName() + " directory structure in module '" + module.getName() + "'?";
        int result = Messages.showDialog((Project)module.getProject(), (String)message, (String)("Create " + this.getDisplayName() + " application"), (String[])new String[]{"Run 'create-&app'", "Run 'create-&plugin'", "&Cancel"}, (int)0, (Icon)this.getIcon());
        if (result < 0 || result > 1) {
            return null;
        }
        return this.createCommandAndShowErrors(null, module, true, new MvcCommand(result == 0 ? "create-app" : "create-plugin", new String[0]));
    }

    public abstract void updateProjectStructure(Module var1);

    public abstract void ensureRunConfigurationExists(Module var1);

    public VirtualFile findAppRoot(Module module) {
        if (module == null) {
            return null;
        }
        String appDirName = this.getApplicationDirectoryName();
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (root.findChild(appDirName) == null) continue;
            return root;
        }
        return null;
    }

    public VirtualFile findAppRoot(PsiElement element) {
        VirtualFile appDirectory = this.findAppDirectory(element);
        return appDirectory == null ? null : appDirectory.getParent();
    }

    public VirtualFile findAppDirectory(Module module) {
        if (module == null) {
            return null;
        }
        String appDirName = this.getApplicationDirectoryName();
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile res = root.findChild(appDirName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public VirtualFile findAppDirectory(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile().getOriginalFile();
        VirtualFile file = containingFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex();
        VirtualFile root = index.getContentRootForFile(file);
        if (root == null) {
            return null;
        }
        return root.findChild(this.getApplicationDirectoryName());
    }

    public abstract VirtualFile getSdkRoot(Module var1);

    public abstract String getUserLibraryName();

    protected abstract boolean isCoreJar(VirtualFile var1);

    protected List<File> getImplicitClasspathRoots(Module module) {
        Library library;
        ArrayList<File> toExclude = new ArrayList<File>();
        VirtualFile sdkRoot = this.getSdkRoot(module);
        if (sdkRoot != null) {
            toExclude.add(VfsUtil.virtualToIoFile((VirtualFile)sdkRoot));
        }
        ContainerUtil.addIfNotNull((Object)this.getCommonPluginsDir(module), toExclude);
        VirtualFile appRoot = this.findAppRoot(module);
        if (appRoot != null) {
            VirtualFile libDir;
            VirtualFile pluginDir = appRoot.findChild("plugins");
            if (pluginDir != null) {
                toExclude.add(VfsUtil.virtualToIoFile((VirtualFile)pluginDir));
            }
            if ((libDir = appRoot.findChild("lib")) != null) {
                toExclude.add(VfsUtil.virtualToIoFile((VirtualFile)libDir));
            }
        }
        if ((library = MvcModuleStructureUtil.findUserLibrary(module, this.getUserLibraryName())) != null) {
            for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                toExclude.add(VfsUtil.virtualToIoFile((VirtualFile)PathUtil.getLocalFile((VirtualFile)file)));
            }
        }
        return toExclude;
    }

    private PathsList removeFrameworkStuff(Module module, List<VirtualFile> rootFiles) {
        List<File> toExclude = this.getImplicitClasspathRoots(module);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before removing framework stuff: " + rootFiles);
            LOG.debug("Implicit roots:" + toExclude);
        }
        PathsList scriptClassPath = new PathsList();
        block0: for (VirtualFile file : rootFiles) {
            for (File excluded : toExclude) {
                if (!VfsUtil.isAncestor((File)excluded, (File)VfsUtil.virtualToIoFile((VirtualFile)file), (boolean)false)) continue;
                continue block0;
            }
            scriptClassPath.add(file);
        }
        return scriptClassPath;
    }

    public PathsList getApplicationClassPath(Module module) {
        List classPath = OrderEnumerator.orderEntries((Module)module).recursively().withoutSdk().getPathsList().getVirtualFiles();
        MvcFramework.retainOnlyJarsAndDirectories(classPath);
        MvcFramework.removeModuleOutput(module, classPath);
        Module pluginsModule = this.findCommonPluginsModule(module);
        if (pluginsModule != null) {
            MvcFramework.removeModuleOutput(pluginsModule, classPath);
        }
        return this.removeFrameworkStuff(module, classPath);
    }

    public abstract boolean updatesWholeProject();

    private static void retainOnlyJarsAndDirectories(List<VirtualFile> woSdk) {
        Iterator<VirtualFile> iterator = woSdk.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(file);
            boolean dir = file.isDirectory();
            String name = file.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Considering: " + file.getPath() + "; local=" + local + "; dir=" + dir + "; name=" + name);
            }
            if (dir || local != null || name.endsWith(".jar")) continue;
            LOG.debug("Removing");
            iterator.remove();
        }
    }

    private static void removeModuleOutput(Module module, List<VirtualFile> from) {
        CompilerModuleExtension extension = (CompilerModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(CompilerModuleExtension.class);
        from.remove(extension.getCompilerOutputPath());
        from.remove(extension.getCompilerOutputPathForTests());
    }

    public abstract JavaParameters createJavaParameters(Module var1, boolean var2, boolean var3, boolean var4, String var5, MvcCommand var6) throws ExecutionException;

    protected static void ensureRunConfigurationExists(Module module, ConfigurationType configurationType, String name) {
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        for (RunConfiguration runConfiguration : runManager.getConfigurationsList(configurationType)) {
            if (!(runConfiguration instanceof MvcRunConfiguration) || ((MvcRunConfiguration)runConfiguration).getModule() != module) continue;
            return;
        }
        ConfigurationFactory factory = configurationType.getConfigurationFactories()[0];
        RunnerAndConfigurationSettings runSettings = runManager.createRunConfiguration(name, factory);
        MvcRunConfiguration configuration = (MvcRunConfiguration)runSettings.getConfiguration();
        configuration.setModule(module);
        runManager.addConfiguration(runSettings, false);
        runManager.setSelectedConfiguration(runSettings);
        RunManagerEx.disableTasks((Project)module.getProject(), (RunConfiguration)configuration, (Key[])new Key[]{CompileStepBeforeRun.ID, CompileStepBeforeRunNoErrorCheck.ID});
    }

    public abstract String getFrameworkName();

    public String getDisplayName() {
        return this.getFrameworkName();
    }

    public abstract Icon getIcon();

    public abstract Icon getToolWindowIcon();

    public abstract String getSdkHomePropertyName();

    public GeneralCommandLine createCommandAndShowErrors(Module module, String command, String ... args) {
        return this.createCommandAndShowErrors(null, module, new MvcCommand(command, args));
    }

    public GeneralCommandLine createCommandAndShowErrors(Module module, MvcCommand command) {
        return this.createCommandAndShowErrors(null, module, command);
    }

    public GeneralCommandLine createCommandAndShowErrors(String vmOptions, Module module, MvcCommand command) {
        return this.createCommandAndShowErrors(vmOptions, module, false, command);
    }

    public GeneralCommandLine createCommandAndShowErrors(String vmOptions, Module module, boolean forCreation, MvcCommand command) {
        try {
            return this.createCommand(module, vmOptions, forCreation, command);
        }
        catch (ExecutionException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)("Failed to run grails command: " + command));
            return null;
        }
    }

    public GeneralCommandLine createCommand(Module module, String jvmParams, boolean forCreation, MvcCommand command) throws ExecutionException {
        VirtualFile root;
        JavaParameters params = this.createJavaParameters(module, forCreation, false, true, jvmParams, command);
        MvcFramework.addJavaHome(params, module);
        GeneralCommandLine commandLine = MvcFramework.createCommandLine(params);
        VirtualFile griffonHome = this.getSdkRoot(module);
        if (griffonHome != null) {
            commandLine.getEnvironment().put(this.getSdkHomePropertyName(), FileUtil.toSystemDependentName((String)griffonHome.getPath()));
        }
        File ioRoot = (root = this.findAppRoot(module)) != null ? VfsUtilCore.virtualToIoFile((VirtualFile)root) : new File(module.getModuleFilePath()).getParentFile();
        commandLine.setWorkDirectory(forCreation ? ioRoot.getParentFile() : ioRoot);
        return commandLine;
    }

    public static void addJavaHome(JavaParameters params, Module module) {
        String path;
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && sdk.getSdkType() instanceof JavaSdkType && StringUtil.isNotEmpty((String)(path = StringUtil.trimEnd((String)sdk.getHomePath(), (String)File.separator)))) {
            params.addEnv("JAVA_HOME", FileUtil.toSystemDependentName((String)path));
        }
    }

    public static GeneralCommandLine createCommandLine(JavaParameters params) throws CantRunException {
        return CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)params);
    }

    private void extractPlugins(Project project, VirtualFile pluginRoot, boolean refreshPluginRoot, Map<String, VirtualFile> res) {
        if (pluginRoot != null) {
            VirtualFile[] children;
            if (refreshPluginRoot) {
                pluginRoot.refresh(false, false);
            }
            if ((children = pluginRoot.getChildren()) != null) {
                for (VirtualFile child : children) {
                    String pluginName = this.getInstalledPluginNameByPath(project, child);
                    if (pluginName == null) continue;
                    res.put(pluginName, child);
                }
            }
        }
    }

    public Collection<VirtualFile> getAllPluginRoots(Module module, boolean refresh) {
        return this.getCommonPluginRoots(module, refresh);
    }

    public void collectCommonPluginRoots(Map<String, VirtualFile> result, Module module, boolean refresh) {
        if (this.isCommonPluginsModule(module)) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                String pluginName = this.getInstalledPluginNameByPath(module.getProject(), root);
                if (pluginName == null) continue;
                result.put(pluginName, root);
            }
        } else {
            VirtualFile root = this.findAppRoot(module);
            if (root == null) {
                return;
            }
            this.extractPlugins(module.getProject(), root.findChild("plugins"), refresh, result);
            this.extractPlugins(module.getProject(), MvcModuleStructureUtil.findFile(this.getCommonPluginsDir(module), refresh), refresh, result);
            this.extractPlugins(module.getProject(), MvcModuleStructureUtil.findFile(this.getGlobalPluginsDir(module), refresh), refresh, result);
        }
    }

    public Collection<VirtualFile> getCommonPluginRoots(Module module, boolean refresh) {
        HashMap<String, VirtualFile> result = new HashMap<String, VirtualFile>();
        this.collectCommonPluginRoots(result, module, refresh);
        return result.values();
    }

    public Module findCommonPluginsModule(Module module) {
        return ModuleManager.getInstance((Project)module.getProject()).findModuleByName(this.getCommonPluginsModuleName(module));
    }

    public boolean isGlobalPluginModule(Module module) {
        return module.getName().startsWith(this.getGlobalPluginsModuleName());
    }

    public File getSdkWorkDir(Module module) {
        return this.getDefaultSdkWorkDir(module);
    }

    public abstract File getDefaultSdkWorkDir(Module var1);

    public File getGlobalPluginsDir(Module module) {
        File sdkWorkDir = this.getSdkWorkDir(module);
        return sdkWorkDir == null ? null : new File(sdkWorkDir, "global-plugins");
    }

    public File getCommonPluginsDir(Module module) {
        File grailsWorkDir = this.getSdkWorkDir(module);
        if (grailsWorkDir == null) {
            return null;
        }
        String applicationName = this.getApplicationName(module);
        if (applicationName == null) {
            return null;
        }
        return new File(grailsWorkDir, "projects/" + applicationName + "/plugins");
    }

    public String getApplicationName(Module module) {
        VirtualFile root = this.findAppRoot(module);
        if (root == null) {
            return null;
        }
        return root.getName();
    }

    protected abstract String getCommonPluginSuffix();

    public abstract String getGlobalPluginsModuleName();

    public String getCommonPluginsModuleName(Module module) {
        return module.getName() + this.getCommonPluginSuffix();
    }

    public abstract boolean isSDKLibrary(Library var1);

    public abstract MvcProjectStructure createProjectStructure(Module var1, boolean var2);

    public abstract LibraryKind getLibraryKind();

    public abstract String getSomeFrameworkClass();

    public static void addAvailableSystemScripts(Collection<String> result, Module module) {
        VirtualFile scriptRoot = null;
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        for (PsiClass aClass : JavaPsiFacade.getInstance((Project)module.getProject()).findClasses("CreateApp_", searchScope)) {
            VirtualFile parent;
            VirtualFile file;
            PsiFile psiFile;
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null || !"groovy.lang.Script".equals(superClass.getQualifiedName()) || (psiFile = aClass.getContainingFile()) == null || (file = psiFile.getVirtualFile()) == null || !(file.getFileSystem() instanceof JarFileSystem) || (parent = file.getParent()) == null || parent.findChild("Console.class") == null) continue;
            scriptRoot = parent;
            break;
        }
        if (scriptRoot == null) {
            return;
        }
        Pattern scriptPattern = Pattern.compile("([A-Za-z0-9]+)_?\\.class");
        for (VirtualFile file : scriptRoot.getChildren()) {
            Matcher matcher = scriptPattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            result.add(GroovyNamesUtil.camelToSnake(matcher.group(1)));
        }
    }

    public abstract boolean isToReformatOnCreation(VirtualFile var1);

    public static void addAvailableScripts(Collection<String> result, VirtualFile root) {
        if (root == null || !root.isDirectory()) {
            return;
        }
        VirtualFile scripts = root.findChild("scripts");
        if (scripts == null || !scripts.isDirectory()) {
            return;
        }
        for (VirtualFile child : scripts.getChildren()) {
            if (!MvcFramework.isScriptFile(child)) continue;
            result.add(GroovyNamesUtil.camelToSnake(child.getNameWithoutExtension()));
        }
    }

    public static MvcFramework findCommonPluginModuleFramework(Module module) {
        for (MvcFramework framework : (MvcFramework[])EP_NAME.getExtensions()) {
            if (!framework.isCommonPluginsModule(module)) continue;
            return framework;
        }
        return null;
    }

    public static boolean isScriptFileName(String fileName) {
        return fileName.endsWith("groovy") && fileName.charAt(0) != '_';
    }

    private static boolean isScriptFile(VirtualFile virtualFile) {
        return !virtualFile.isDirectory() && MvcFramework.isScriptFileName(virtualFile.getName());
    }

    public String getInstalledPluginNameByPath(Project project, VirtualFile pluginPath) {
        VirtualFile pluginXml = pluginPath.findChild("plugin.xml");
        if (pluginXml == null) {
            return null;
        }
        PsiFile pluginXmlPsi = PsiManager.getInstance((Project)project).findFile(pluginXml);
        if (!(pluginXmlPsi instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)pluginXmlPsi).getRootTag();
        if (rootTag == null || !"plugin".equals(rootTag.getName())) {
            return null;
        }
        XmlAttribute attrName = rootTag.getAttribute("name");
        if (attrName == null) {
            return null;
        }
        String res = attrName.getValue();
        if (res == null) {
            return null;
        }
        if ((res = res.trim()).isEmpty()) {
            return null;
        }
        return res;
    }

    public static MvcFramework getInstance(final Module module) {
        if (module == null) {
            return null;
        }
        final Project project = module.getProject();
        return (MvcFramework)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<MvcFramework>(){

            public CachedValueProvider.Result<MvcFramework> compute() {
                ModificationTracker tracker = MvcModuleStructureSynchronizer.getInstance(project).getFileAndRootsModificationTracker();
                for (MvcFramework framework : (MvcFramework[])EP_NAME.getExtensions()) {
                    if (!framework.hasSupport(module)) continue;
                    return CachedValueProvider.Result.create((Object)framework, (Object[])new Object[]{tracker});
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{tracker});
            }
        });
    }

    public static MvcFramework getInstanceBySdk(Module module) {
        for (MvcFramework framework : (MvcFramework[])EP_NAME.getExtensions()) {
            if (framework.getSdkRoot(module) == null) continue;
            return framework;
        }
        return null;
    }
}

