/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcConfigureNotification
extends GroovyFrameworkConfigNotification {
    private final MvcFramework framework;

    public MvcConfigureNotification(MvcFramework framework) {
        this.framework = framework;
    }

    @Override
    public boolean hasFrameworkStructure(Module module) {
        VirtualFile appDir = this.framework.findAppDirectory(module);
        if (appDir == null) {
            return false;
        }
        return appDir.findChild("controllers") != null && appDir.findChild("conf") != null;
    }

    @Override
    public boolean hasFrameworkLibrary(Module module) {
        return this.framework.hasFrameworkJar(module);
    }

    public static void configure(MvcFramework framework, Module module) {
        GroovyLibraryDescription description = framework.createLibraryDescription();
        AddCustomLibraryDialog dialog = AddCustomLibraryDialog.createDialog((CustomLibraryDescription)description, (Module)module, null);
        dialog.setTitle("Change " + framework.getDisplayName() + " SDK version");
        if (dialog.showAndGet()) {
            module.putUserData(MvcFramework.UPGRADE, (Object)Boolean.TRUE);
        }
    }

    public EditorNotificationPanel createConfigureNotificationPanel(final Module module) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(this.framework.getFrameworkName() + " SDK is not configured for module '" + module.getName() + '\'');
        panel.createActionLabel("Configure " + this.framework.getFrameworkName() + " SDK", new Runnable(){

            @Override
            public void run() {
                MvcConfigureNotification.configure(MvcConfigureNotification.this.framework, module);
            }
        });
        return panel;
    }
}

