/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class MethodResolverProcessor
extends ResolverProcessor
implements GrMethodComparator.Context {
    private final PsiType myThisType;
    private final PsiType[] myArgumentTypes;
    private final boolean myAllVariants;
    private Set<GroovyResolveResult> myInapplicableCandidates = null;
    private final boolean myIsConstructor;
    private boolean myStopExecuting = false;
    private final boolean myByShape;
    private final SubstitutorComputer mySubstitutorComputer;

    public MethodResolverProcessor(String name, PsiElement place, boolean isConstructor, PsiType thisType, PsiType[] argumentTypes, PsiType[] typeArguments) {
        this(name, place, isConstructor, thisType, argumentTypes, typeArguments, false, false);
    }

    public MethodResolverProcessor(String name, PsiElement place, boolean isConstructor, PsiType thisType, PsiType[] argumentTypes, PsiType[] typeArguments, boolean allVariants, boolean byShape) {
        super(name, RESOLVE_KINDS_METHOD_PROPERTY, place, PsiType.EMPTY_ARRAY);
        this.myIsConstructor = isConstructor;
        this.myThisType = thisType;
        this.myArgumentTypes = argumentTypes;
        this.myAllVariants = allVariants;
        this.myByShape = byShape;
        this.mySubstitutorComputer = new SubstitutorComputer(this.myThisType, this.myArgumentTypes, typeArguments, this.myPlace, this.myPlace.getParent());
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        if (this.myStopExecuting) {
            return false;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor() != this.myIsConstructor) {
                return true;
            }
            PsiSubstitutor substitutor = this.inferSubstitutor(method, state);
            PsiElement resolveContext = (PsiElement)state.get(RESOLVE_CONTEXT);
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            boolean isAccessible = this.isAccessible((PsiNamedElement)method);
            boolean isStaticsOK = this.isStaticsOK((PsiNamedElement)method, resolveContext, false);
            boolean isApplicable = PsiUtil.isApplicable(this.myArgumentTypes, method, substitutor, this.myPlace, this.myByShape);
            boolean isValidResult = isStaticsOK && isAccessible && isApplicable;
            GroovyResolveResultImpl candidate = new GroovyResolveResultImpl((PsiElement)method, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK, false, isValidResult);
            if (!this.myAllVariants && isValidResult) {
                this.addCandidate(candidate);
            } else {
                this.addInapplicableCandidate(candidate);
            }
        }
        return true;
    }

    protected boolean addInapplicableCandidate(GroovyResolveResult candidate) {
        if (this.myInapplicableCandidates == null) {
            this.myInapplicableCandidates = ContainerUtil.newLinkedHashSet();
        }
        return this.myInapplicableCandidates.add(candidate);
    }

    private PsiSubstitutor inferSubstitutor(PsiMethod method, ResolveState state) {
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        return this.myByShape ? substitutor : this.mySubstitutorComputer.obtainSubstitutor(substitutor, method, state);
    }

    @Override
    public GroovyResolveResult[] getCandidates() {
        if (!this.myAllVariants && this.hasApplicableCandidates()) {
            return this.filterCandidates();
        }
        if (this.myInapplicableCandidates != null && !this.myInapplicableCandidates.isEmpty()) {
            Set<GroovyResolveResult> resultSet = this.myAllVariants ? this.myInapplicableCandidates : this.filterCorrectParameterCount(this.myInapplicableCandidates);
            return ResolveUtil.filterSameSignatureCandidates(resultSet);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private Set<GroovyResolveResult> filterCorrectParameterCount(Set<GroovyResolveResult> candidates) {
        if (this.myArgumentTypes == null) {
            return candidates;
        }
        HashSet result = new HashSet();
        for (GroovyResolveResult candidate : candidates) {
            PsiElement element = candidate.getElement();
            if (!(element instanceof PsiMethod) || ((PsiMethod)element).getParameterList().getParametersCount() != this.myArgumentTypes.length) continue;
            result.add(candidate);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return candidates;
    }

    private GroovyResolveResult[] filterCandidates() {
        List<GroovyResolveResult> array = this.getCandidatesInternal();
        if (array.size() == 1) {
            return array.toArray(new GroovyResolveResult[array.size()]);
        }
        ArrayList<GroovyResolveResult> result = new ArrayList<GroovyResolveResult>();
        Iterator<GroovyResolveResult> itr = array.iterator();
        result.add(itr.next());
        block0: while (itr.hasNext()) {
            GroovyResolveResult resolveResult = itr.next();
            PsiElement currentElement = resolveResult.getElement();
            if (currentElement instanceof PsiMethod) {
                PsiMethod currentMethod = (PsiMethod)currentElement;
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    GroovyResolveResult otherResolveResult = (GroovyResolveResult)iterator.next();
                    PsiElement other = otherResolveResult.getElement();
                    if (!(other instanceof PsiMethod)) continue;
                    PsiMethod otherMethod = (PsiMethod)other;
                    int res = this.compareMethods(currentMethod, resolveResult.getSubstitutor(), resolveResult.getCurrentFileResolveContext(), otherMethod, otherResolveResult.getSubstitutor(), otherResolveResult.getCurrentFileResolveContext());
                    if (res > 0) continue block0;
                    if (res >= 0) continue;
                    iterator.remove();
                }
            }
            result.add(resolveResult);
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }

    private int compareMethods(PsiMethod method1, PsiSubstitutor substitutor1, PsiElement resolveContext1, PsiMethod method2, PsiSubstitutor substitutor2, PsiElement resolveContext2) {
        if (!method1.getName().equals(method2.getName())) {
            return 0;
        }
        if (this.secondMethodIsPreferable(method1, substitutor1, resolveContext1, method2, substitutor2, resolveContext2)) {
            if (this.secondMethodIsPreferable(method2, substitutor2, resolveContext2, method1, substitutor1, resolveContext1) && method2 instanceof GrGdkMethod && !(method1 instanceof GrGdkMethod)) {
                return -1;
            }
            return 1;
        }
        if (this.secondMethodIsPreferable(method2, substitutor2, resolveContext2, method1, substitutor1, resolveContext1)) {
            return -1;
        }
        return 0;
    }

    private boolean secondMethodIsPreferable(PsiMethod method1, PsiSubstitutor substitutor1, PsiElement resolveContext1, PsiMethod method2, PsiSubstitutor substitutor2, PsiElement resolveContext2) {
        PsiType returnType2;
        PsiType returnType1;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        Boolean custom = GrMethodComparator.checkDominated(method1, substitutor1, method2, substitutor2, this);
        if (custom != null) {
            return custom;
        }
        PsiType[] argTypes = this.myArgumentTypes;
        if (method1 instanceof GrGdkMethod && method2 instanceof GrGdkMethod) {
            method1 = ((GrGdkMethod)method1).getStaticMethod();
            method2 = ((GrGdkMethod)method2).getStaticMethod();
            if (this.myArgumentTypes != null) {
                argTypes = PsiType.createArray((int)(argTypes.length + 1));
                System.arraycopy(this.myArgumentTypes, 0, argTypes, 1, this.myArgumentTypes.length);
                argTypes[0] = this.myThisType;
            }
        } else {
            if (method1 instanceof GrGdkMethod) {
                return true;
            }
            if (method2 instanceof GrGdkMethod) {
                return false;
            }
        }
        if (this.myIsConstructor && argTypes != null && argTypes.length == 1) {
            if (method1.getParameterList().getParametersCount() == 0) {
                return true;
            }
            if (method2.getParameterList().getParametersCount() == 0) {
                return false;
            }
        }
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        if (argTypes == null && params1.length != params2.length) {
            return false;
        }
        if (params1.length < params2.length) {
            if (params1.length == 0) {
                return false;
            }
            PsiType lastType = params1[params1.length - 1].getType();
            return lastType instanceof PsiArrayType;
        }
        for (int i = 0; i < params2.length; ++i) {
            PsiType argType;
            PsiType ptype1 = params1[i].getType();
            PsiType ptype2 = params2[i].getType();
            PsiType type1 = substitutor1.substitute(ptype1);
            PsiType type2 = substitutor2.substitute(ptype2);
            if (argTypes != null && argTypes.length > i && (argType = argTypes[i]) != null) {
                boolean converts2;
                boolean converts1 = TypesUtil.isAssignableWithoutConversions(TypeConversionUtil.erasure((PsiType)type1), argType, this.myPlace);
                if (converts1 != (converts2 = TypesUtil.isAssignableWithoutConversions(TypeConversionUtil.erasure((PsiType)type2), argType, this.myPlace))) {
                    return converts2;
                }
                if (TypesUtil.resolvesTo(type1, "java.util.concurrent.Callable") && TypesUtil.resolvesTo(type2, "java.lang.Runnable") && InheritanceUtil.isInheritor((PsiType)argType, (String)"groovy.lang.GroovyCallable")) {
                    return true;
                }
            }
            if (!this.typesAgree(TypeConversionUtil.erasure((PsiType)ptype1), TypeConversionUtil.erasure((PsiType)ptype2))) {
                return false;
            }
            if (resolveContext1 != null && resolveContext2 == null) {
                return !TypesUtil.resolvesTo(type1, "java.lang.Object") || !TypesUtil.resolvesTo(type2, "java.lang.Object");
            }
            if (resolveContext1 != null || resolveContext2 == null) continue;
            return true;
        }
        return method1 instanceof SyntheticElement || method2 instanceof SyntheticElement || TypesUtil.isAssignableWithoutConversions(returnType1 = substitutor1.substitute(method1.getReturnType()), returnType2 = substitutor2.substitute(method2.getReturnType()), this.myPlace) || !TypesUtil.isAssignableWithoutConversions(returnType2, returnType1, this.myPlace);
    }

    private boolean typesAgree(PsiType type1, PsiType type2) {
        if (this.argumentsSupplied() && type1 instanceof PsiArrayType && !(type2 instanceof PsiArrayType)) {
            type1 = ((PsiArrayType)type1).getComponentType();
        }
        return this.argumentsSupplied() ? TypesUtil.isAssignableWithoutConversions(type1, type2, this.myPlace) : type1.equals(type2);
    }

    private boolean argumentsSupplied() {
        return this.myArgumentTypes != null;
    }

    @Override
    public boolean hasCandidates() {
        return this.hasApplicableCandidates() || this.myInapplicableCandidates != null && !this.myInapplicableCandidates.isEmpty();
    }

    public boolean hasApplicableCandidates() {
        return super.hasCandidates();
    }

    @Override
    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public PsiType[] getTypeArguments() {
        return this.mySubstitutorComputer.getTypeArguments();
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        super.handleEvent(event, associated);
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && this.hasApplicableCandidates()) {
            this.myStopExecuting = true;
        }
    }

    @Override
    public PsiType getThisType() {
        return this.myThisType;
    }

    @Override
    public PsiElement getPlace() {
        return this.myPlace;
    }
}

