/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class AccessorResolverProcessor
extends MethodResolverProcessor {
    private final String myPropertyName;
    private final boolean mySearchForGetter;
    private final SubstitutorComputer mySubstitutorComputer;

    public AccessorResolverProcessor(String accessorName, String propertyName, PsiElement place, boolean searchForGetter) {
        this(accessorName, propertyName, place, searchForGetter, false, null, PsiType.EMPTY_ARRAY);
    }

    public AccessorResolverProcessor(String accessorName, String propertyName, PsiElement place, boolean searchForGetter, boolean byShape, PsiType thisType, PsiType[] typeArguments) {
        super(accessorName, place, false, thisType, null, typeArguments, false, byShape);
        this.myPropertyName = propertyName;
        this.mySearchForGetter = searchForGetter;
        this.mySubstitutorComputer = byShape ? null : new SubstitutorComputer(thisType, PsiType.EMPTY_ARRAY, typeArguments, place, this.myPlace);
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        String importedName;
        PsiElement resolveContext = (PsiElement)state.get(RESOLVE_CONTEXT);
        String string = importedName = resolveContext instanceof GrImportStatement ? ((GrImportStatement)resolveContext).getImportedName() : null;
        if (this.mySearchForGetter ? element instanceof PsiMethod && (importedName != null && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForGetter((PsiMethod)element, importedName, this.myPropertyName) || this.myPropertyName.equals(importedName)) || importedName == null && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, this.myPropertyName)) : element instanceof PsiMethod && (importedName != null && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForSetter(importedName, this.myPropertyName) || this.myPropertyName.equals(importedName)) || importedName == null && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, this.myPropertyName))) {
            return this.addAccessor((PsiMethod)element, state);
        }
        return true;
    }

    private static boolean isAppropriatePropertyNameForSetter(String importedName, String propertyName) {
        propertyName = GroovyPropertyUtils.decapitalize(propertyName);
        return propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetterName(importedName));
    }

    private static boolean isAppropriatePropertyNameForGetter(PsiMethod getter, String importedNameForGetter, String propertyName) {
        propertyName = GroovyPropertyUtils.decapitalize(propertyName);
        return propertyName.equals(AccessorResolverProcessor.getPropertyNameByGetter(getter, importedNameForGetter));
    }

    private static String getPropertyNameByGetter(PsiMethod element, String importedName) {
        return GroovyPropertyUtils.getPropertyNameByGetterName(importedName, AccessorResolverProcessor.isBoolean(element));
    }

    private static boolean isBoolean(PsiMethod method) {
        return method.getReturnType() == PsiType.BOOLEAN;
    }

    private boolean addAccessor(PsiMethod method, ResolveState state) {
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        if (this.mySubstitutorComputer != null) {
            substitutor = this.mySubstitutorComputer.obtainSubstitutor(substitutor, method, state);
        }
        boolean isAccessible = this.isAccessible((PsiNamedElement)method);
        PsiElement resolveContext = (PsiElement)state.get(RESOLVE_CONTEXT);
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        boolean isStaticsOK = this.isStaticsOK((PsiNamedElement)method, resolveContext, false);
        GroovyResolveResultImpl candidate = new GroovyResolveResultImpl((PsiElement)method, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK, true, true);
        if (isAccessible && isStaticsOK) {
            this.addCandidate(candidate);
            return method instanceof GrGdkMethod;
        }
        this.addInapplicableCandidate(candidate);
        return true;
    }

    @Override
    public GroovyResolveResult[] getCandidates() {
        boolean hasApplicableCandidates = this.hasApplicableCandidates();
        GroovyResolveResult[] candidates = super.getCandidates();
        if (hasApplicableCandidates) {
            if (candidates.length <= 1) {
                return candidates;
            }
            return new GroovyResolveResult[]{candidates[0]};
        }
        return candidates;
    }
}

