/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.dsl.GdslMembersHolderConsumer;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.dsltop.GdslMembersProvider;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GdkMethodDslProvider
implements GdslMembersProvider {
    public void category(String className, GdslMembersHolderConsumer consumer) {
        GdkMethodDslProvider.processCategoryMethods(className, consumer, false);
    }

    public void category(String className, boolean isStatic, GdslMembersHolderConsumer consumer) {
        GdkMethodDslProvider.processCategoryMethods(className, consumer, isStatic);
    }

    private static void processCategoryMethods(String className, GdslMembersHolderConsumer consumer, final boolean isStatic) {
        final GlobalSearchScope scope = consumer.getResolveScope();
        final PsiClass categoryClass = GroovyPsiManager.getInstance(consumer.getProject()).findClassWithCache(className, scope);
        if (categoryClass == null) {
            return;
        }
        VolatileNotNullLazyValue<GdkMethodHolder> methodsMap = new VolatileNotNullLazyValue<GdkMethodHolder>(){

            protected GdkMethodHolder compute() {
                return GdkMethodHolder.getHolderForClass(categoryClass, isStatic, scope);
            }
        };
        consumer.addMemberHolder(new CustomMembersHolder((VolatileNotNullLazyValue)methodsMap){
            final /* synthetic */ VolatileNotNullLazyValue val$methodsMap;
            {
                this.val$methodsMap = volatileNotNullLazyValue;
            }

            @Override
            public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor processor, ResolveState state) {
                return ((GdkMethodHolder)this.val$methodsMap.getValue()).processMethods(processor, state, descriptor.getPsiType(), descriptor.getProject());
            }
        });
    }
}

