/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrTraitUtil {
    private static final Logger LOG = Logger.getInstance(GrTraitUtil.class);

    public static boolean isInterface(PsiClass aClass) {
        return aClass != null && aClass.isInterface() && !GrTraitUtil.isTrait(aClass);
    }

    public static boolean isMethodAbstract(PsiMethod method) {
        if (method.getModifierList().hasExplicitModifier("abstract")) {
            return true;
        }
        PsiClass aClass = method.getContainingClass();
        return GrTraitUtil.isInterface(aClass);
    }

    public static String getTraitFieldPrefix(PsiClass aClass) {
        String qname = aClass.getQualifiedName();
        LOG.assertTrue(qname != null, aClass.getClass());
        String[] idents = qname.split("\\.");
        StringBuilder buffer = new StringBuilder();
        for (String ident : idents) {
            buffer.append(ident).append("_");
        }
        buffer.append("_");
        return buffer.toString();
    }

    public static boolean isTrait(PsiClass containingClass) {
        return containingClass instanceof GrTypeDefinition && ((GrTypeDefinition)containingClass).isTrait();
    }
}

