/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrInnerClassConstructorUtil {
    public static GrParameter[] addEnclosingInstanceParam(GrMethod method, PsiClass enclosingClass, GrParameter[] originalParams, boolean isOptional) {
        GrParameter[] parameters = new GrParameter[originalParams.length + 1];
        PsiClassType enclosingClassType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(enclosingClass, PsiSubstitutor.EMPTY);
        GrLightParameter enclosing = new GrLightParameter("enclosing", (PsiType)enclosingClassType, method);
        if (isOptional) {
            enclosing.setOptional(true);
            enclosing.setInitializerGroovy(GroovyPsiElementFactory.getInstance(method.getProject()).createExpressionFromText("null"));
        }
        parameters[0] = enclosing;
        System.arraycopy(originalParams, 0, parameters, 1, originalParams.length);
        return parameters;
    }

    public static boolean isInnerClassConstructorUsedOutsideOfItParent(PsiMethod method, PsiElement place) {
        PsiClass containingClass;
        PsiClass aClass;
        return method instanceof GrMethod && method.isConstructor() && (aClass = method.getContainingClass()) != null && !aClass.hasModifierProperty("static") && (containingClass = aClass.getContainingClass()) != null && PsiUtil.findEnclosingInstanceClassInScope(containingClass, place, true) == null;
    }

    public static PsiType[] addEnclosingArgIfNeeded(PsiType[] types, PsiElement place, PsiClass aClass) {
        PsiClass containingClass;
        if (!aClass.hasModifierProperty("static") && (containingClass = aClass.getContainingClass()) != null) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
            PsiClass scopeClass = PsiUtil.findEnclosingInstanceClassInScope(containingClass, place, true);
            if (scopeClass != null) {
                PsiType[] newTypes = PsiType.createArray((int)(types.length + 1));
                newTypes[0] = factory.createType(scopeClass);
                System.arraycopy(types, 0, newTypes, 1, types.length);
                types = newTypes;
            } else if (types.length == 0 || !TypesUtil.isAssignableByMethodCallConversion((PsiType)factory.createType(containingClass), types[0], place)) {
                PsiType[] newTypes = PsiType.createArray((int)(types.length + 1));
                newTypes[0] = PsiType.NULL;
                System.arraycopy(types, 0, newTypes, 1, types.length);
                types = newTypes;
            }
        }
        return types;
    }
}

