/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;

public class SimpleTypeHintProcessor
extends SignatureHintProcessor {
    @Override
    public String getHintName() {
        return "groovy.transform.stc.SimpleType";
    }

    @Override
    public List<PsiType[]> inferExpectedSignatures(final PsiMethod method, PsiSubstitutor substitutor, String[] options) {
        return Collections.singletonList(ContainerUtil.map((Object[])options, (Function)new Function<String, PsiType>(){

            public PsiType fun(String value) {
                try {
                    PsiType type = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeFromText(value, (PsiElement)method);
                    return DefaultGroovyMethods.asBoolean((Object)type) ? type : PsiType.NULL;
                }
                catch (IncorrectOperationException e) {
                    return PsiType.NULL;
                }
            }
        }, (Object[])new PsiType[options.length]));
    }
}

