/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeConverter {
    public static final ExtensionPointName<GrTypeConverter> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.typeConverter");

    protected static boolean isMethodCallConversion(GroovyPsiElement context) {
        return PsiUtil.isInMethodCallContext(context);
    }

    protected static GrLiteral getLiteral(GroovyPsiElement context) {
        GrExpression expression = context instanceof GrTypeCastExpression ? ((GrTypeCastExpression)context).getOperand() : (context instanceof GrAssignmentExpression ? ((GrAssignmentExpression)context).getRValue() : (context instanceof GrVariable ? ((GrVariable)context).getInitializerGroovy() : (context instanceof GrReturnStatement ? ((GrReturnStatement)context).getReturnValue() : (context instanceof GrExpression ? (GrExpression)context : null))));
        return expression instanceof GrLiteral ? (GrLiteral)expression : null;
    }

    @Deprecated
    public boolean isAllowedInMethodCall() {
        return false;
    }

    public boolean isApplicableTo(ApplicableTo position) {
        switch (position) {
            case EXPLICIT_CAST: {
                return false;
            }
            case ASSIGNMENT: {
                return true;
            }
            case METHOD_PARAMETER: {
                return this.isAllowedInMethodCall();
            }
            case RETURN_VALUE: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public Boolean isConvertible(PsiType lType, PsiType rType, GroovyPsiElement context) {
        return null;
    }

    public ConversionResult isConvertibleEx(PsiType targetType, PsiType actualType, GroovyPsiElement context, ApplicableTo currentPosition) {
        Boolean result = this.isConvertible(targetType, actualType, context);
        return result == null ? null : (result != false ? ConversionResult.OK : ConversionResult.ERROR);
    }

    public static enum ApplicableTo {
        EXPLICIT_CAST,
        ASSIGNMENT,
        METHOD_PARAMETER,
        RETURN_VALUE;

    }
}

