/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;

public class FromAbstractTypeMethodsHintProcessor
extends SignatureHintProcessor {
    @Override
    public String getHintName() {
        return "groovy.transform.stc.FromAbstractTypeMethods";
    }

    @Override
    public List<PsiType[]> inferExpectedSignatures(PsiMethod method, PsiSubstitutor substitutor, String[] options) {
        if (options.length != 1) {
            return Collections.emptyList();
        }
        String qname = options[0];
        PsiClass aClass = JavaPsiFacade.getInstance((Project)method.getProject()).findClass(qname, method.getResolveScope());
        if (aClass == null) {
            return Collections.emptyList();
        }
        Collection abstractSignatures = OverrideImplementExploreUtil.getMethodSignaturesToImplement((PsiClass)aClass);
        return ContainerUtil.map((Collection)abstractSignatures, (Function)new Function<MethodSignature, PsiType[]>(){

            public PsiType[] fun(MethodSignature signature) {
                return signature.getParameterTypes();
            }
        });
    }
}

