/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrDirectInheritorsIndex;

public abstract class GrReferenceListElementType<T extends GrReferenceList>
extends GrStubElementType<GrReferenceListStub, T> {
    public GrReferenceListElementType(String debugName) {
        super(debugName);
    }

    public GrReferenceListStub createStub(T psi, StubElement parentStub) {
        ArrayList<String> refNames = new ArrayList<String>();
        for (GrCodeReferenceElement element : psi.getReferenceElementsGroovy()) {
            String name = element.getText();
            if (!StringUtil.isNotEmpty((String)name)) continue;
            refNames.add(name);
        }
        return new GrReferenceListStub(parentStub, this, ArrayUtil.toStringArray(refNames));
    }

    public void serialize(GrReferenceListStub stub, StubOutputStream dataStream) throws IOException {
        GrStubUtils.writeStringArray(dataStream, stub.getBaseClasses());
    }

    public GrReferenceListStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        return new GrReferenceListStub(parentStub, this, GrStubUtils.readStringArray(dataStream));
    }

    @Override
    public void indexStub(GrReferenceListStub stub, IndexSink sink) {
        for (String name : stub.getBaseClasses()) {
            if (name == null) continue;
            sink.occurrence(GrDirectInheritorsIndex.KEY, (Object)PsiNameHelper.getShortClassName((String)name));
        }
    }

    public boolean isLeftBound() {
        return true;
    }
}

