/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ProcessingContext;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyExpressionPattern;

public class GroovyMethodCallPattern
extends GroovyExpressionPattern<GrCallExpression, GroovyMethodCallPattern> {
    GroovyMethodCallPattern() {
        super(GrCallExpression.class);
    }

    public GroovyMethodCallPattern withArguments(final ElementPattern<? extends GrExpression> ... arguments) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>("withArguments"){

            public boolean accepts(GrCallExpression callExpression, ProcessingContext context) {
                GrArgumentList argumentList = callExpression.getArgumentList();
                if (argumentList == null) {
                    return false;
                }
                GrExpression[] actualArguments = argumentList.getExpressionArguments();
                if (arguments.length != actualArguments.length) {
                    return false;
                }
                for (int i = 0; i < actualArguments.length; ++i) {
                    if (arguments[i].accepts((Object)actualArguments[i], context)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public GroovyMethodCallPattern withMethodName(String methodName) {
        return this.withMethodName((ElementPattern<? extends String>)StandardPatterns.string().equalTo((Object)methodName));
    }

    public GroovyMethodCallPattern withMethodName(final ElementPattern<? extends String> methodName) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>("withMethodName"){

            public boolean accepts(GrCallExpression callExpression, ProcessingContext context) {
                if (!(callExpression instanceof GrMethodCall)) {
                    return false;
                }
                GrExpression expression = ((GrMethodCall)callExpression).getInvokedExpression();
                if (!(expression instanceof GrReferenceExpression)) {
                    return false;
                }
                GrReferenceExpression refExpression = (GrReferenceExpression)expression;
                return methodName.accepts((Object)refExpression.getReferenceName(), context);
            }
        });
    }

    public GroovyMethodCallPattern withMethod(final ElementPattern<? extends PsiMethod> methodPattern) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>("methodCall"){

            public boolean accepts(GrCallExpression callExpression, ProcessingContext context) {
                for (GroovyResolveResult result : callExpression.getCallVariants(null)) {
                    if (!methodPattern.accepts((Object)result.getElement(), context)) continue;
                    return true;
                }
                return false;
            }
        });
    }
}

