/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.toplevel.packaging;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrPackageDefinitionImpl
extends GrStubElementBase<GrPackageDefinitionStub>
implements GrPackageDefinition,
StubBasedPsiElement<GrPackageDefinitionStub> {
    public GrPackageDefinitionImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    public GrPackageDefinitionImpl(GrPackageDefinitionStub stub) {
        super(stub, GroovyElementTypes.PACKAGE_DEFINITION);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitPackageDefinition(this);
    }

    public String toString() {
        return "Package definition";
    }

    @Override
    public String getPackageName() {
        GrPackageDefinitionStub stub = (GrPackageDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getPackageName();
        }
        GrCodeReferenceElement ref = this.getPackageReference();
        if (ref == null) {
            return "";
        }
        return PsiUtil.getQualifiedReferenceText(ref);
    }

    @Override
    public GrCodeReferenceElement getPackageReference() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public GrModifierList getAnnotationList() {
        return (GrModifierList)this.getStubOrPsiChild(GroovyElementTypes.MODIFIERS);
    }

    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    public boolean hasModifierProperty(String name) {
        PsiModifierList list = this.getModifierList();
        return list != null && list.hasExplicitModifier(name);
    }
}

