/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import icons.JetgroovyIcons;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrAccessorMethodImpl
extends LightMethodBuilder
implements GrAccessorMethod {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrAccessorMethodImpl");
    private final GrField myProperty;
    private final boolean myIsSetter;

    public GrAccessorMethodImpl(GrField property, boolean isSetter, String name) {
        super(property.getManager(), (Language)GroovyLanguage.INSTANCE, name, (PsiParameterList)new LightParameterListBuilder(property.getManager(), (Language)GroovyLanguage.INSTANCE), (PsiModifierList)new LightModifierList(property.getManager()){

            public String getText() {
                String[] modifiers = this.getModifiers();
                if (modifiers.length == 0) {
                    return "";
                }
                if (modifiers.length == 1) {
                    return modifiers[0];
                }
                return StringUtil.join((String[])modifiers, (String)" ");
            }
        });
        this.myProperty = property;
        this.myIsSetter = isSetter;
        if (this.myIsSetter) {
            PsiType type = this.myProperty.getDeclaredType();
            if (type == null) {
                type = TypesUtil.getJavaLangObject(this.myProperty);
            }
            this.addParameter(this.myProperty.getName(), type);
        }
        this.setMethodReturnType((PsiType)(this.myIsSetter ? PsiType.VOID : this.myProperty.getType()));
        this.addModifier("public");
        if (this.myProperty.hasModifierProperty("static")) {
            this.addModifier("static");
        } else if (this.myProperty.hasModifierProperty("final")) {
            this.addModifier("final");
        }
        if (GrTraitUtil.isTrait(property.getContainingClass())) {
            this.addModifier("abstract");
        }
        this.setNavigationElement(property);
        this.setBaseIcon(JetgroovyIcons.Groovy.Property);
        this.setContainingClass(this.myProperty.getContainingClass());
        this.setMethodKind("AccessorMethod");
        this.setOriginInfo("synthetic accessor for '" + this.myProperty.getName() + "'");
    }

    @Override
    public PsiType getInferredReturnType() {
        if (this.myIsSetter) {
            return PsiType.VOID;
        }
        return this.myProperty.getTypeGroovy();
    }

    @Override
    public boolean isSetter() {
        return this.myIsSetter;
    }

    public PsiElement copy() {
        String modifiers = this.getModifierList().getText();
        String params = this.myIsSetter ? "(" + this.myProperty.getName() + ")" : "()";
        return GroovyPsiElementFactory.getInstance(this.getProject()).createMethodFromText(modifiers + " " + this.getName() + params + "{}");
    }

    @Override
    public GrField getProperty() {
        return this.myProperty;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another == this) {
            return true;
        }
        if (!(another instanceof GrAccessorMethod)) {
            return false;
        }
        if (!((GrAccessorMethod)another).getName().equals(this.getName())) {
            return false;
        }
        return this.getManager().areElementsEquivalent((PsiElement)this.myProperty, (PsiElement)((GrAccessorMethod)another).getProperty());
    }

    public static GrAccessorMethod createSetterMethod(GrField field) {
        PsiClass clazz;
        String fieldName;
        String name;
        GrAccessorMethodImpl setter;
        if (field.isProperty() && !field.hasModifierProperty("final") && !GrAccessorMethodImpl.hasContradictingMethods(setter = new GrAccessorMethodImpl(field, true, name = GroovyPropertyUtils.getSetterName(fieldName = field.getName())), fieldName, clazz = field.getContainingClass())) {
            return setter;
        }
        return null;
    }

    public static GrAccessorMethod[] createGetterMethods(GrField field) {
        if (field.isProperty()) {
            String fieldName = field.getName();
            PsiClass clazz = field.getContainingClass();
            GrAccessorMethodImpl getter1 = new GrAccessorMethodImpl(field, false, GroovyPropertyUtils.getGetterNameNonBoolean(fieldName));
            if (!GrAccessorMethodImpl.hasContradictingMethods(getter1, fieldName, clazz)) {
                GrAccessorMethodImpl getter2 = null;
                if (PsiType.BOOLEAN.equals((Object)field.getDeclaredType()) && GrAccessorMethodImpl.hasContradictingMethods(getter2 = new GrAccessorMethodImpl(field, false, GroovyPropertyUtils.getGetterNameBoolean(fieldName)), fieldName, clazz)) {
                    getter2 = null;
                }
                if (getter2 != null) {
                    return new GrAccessorMethod[]{getter1, getter2};
                }
                return new GrAccessorMethod[]{getter1};
            }
        }
        return GrAccessorMethod.EMPTY_ARRAY;
    }

    private static boolean hasContradictingMethods(GrAccessorMethod proto, String fieldName, PsiClass clazz) {
        PsiField field;
        if (clazz == null) {
            return false;
        }
        PsiMethod[] methods = clazz instanceof GrTypeDefinition ? ((GrTypeDefinition)clazz).findCodeMethodsByName(proto.getName(), true) : clazz.findMethodsByName(proto.getName(), true);
        int paramCount = proto.getParameterList().getParametersCount();
        for (PsiMethod method : methods) {
            if (paramCount != method.getParameterList().getParametersCount()) continue;
            if (clazz.equals(method.getContainingClass())) {
                return true;
            }
            if (!PsiUtil.isAccessible((PsiElement)clazz, (PsiMember)method) || !method.hasModifierProperty("final")) continue;
            return true;
        }
        PsiClass aSuper = clazz.getSuperClass();
        return aSuper != null && (field = aSuper.findFieldByName(fieldName, true)) instanceof GrField && ((GrField)field).isProperty() && field.hasModifierProperty("final");
    }

    public PsiElement getPrototype() {
        return this.getProperty();
    }
}

