/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReassignedLocalVarsChecker;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyTargetElementEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.impl.InferenceContext;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceResolveRunner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrSuperReferenceResolver;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrThisReferenceResolver;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;
import org.jetbrains.plugins.groovy.util.ResolveProfiler;

public class GrReferenceExpressionImpl
extends GrReferenceElementImpl<GrExpression>
implements GrReferenceExpression {
    private static final Logger LOG = Logger.getInstance(GrReferenceExpressionImpl.class);
    private static final ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl> POLY_RESOLVER = new ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl>(){

        public GroovyResolveResult[] resolve(GrReferenceExpressionImpl refExpr, boolean incompleteCode) {
            return refExpr.doPolyResolve(incompleteCode, true);
        }
    };
    private static final OurTypesCalculator TYPES_CALCULATOR = new OurTypesCalculator();

    public GrReferenceExpressionImpl(ASTNode node) {
        super(node);
    }

    private boolean findClassOrPackageAtFirst() {
        String name = this.getReferenceName();
        if (StringUtil.isEmpty((String)name) || this.hasAt()) {
            return false;
        }
        return Character.isUpperCase(name.charAt(0)) && !this.isMethodCallRef() || this.getParent() instanceof GrReferenceExpressionImpl && ((GrReferenceExpressionImpl)this.getParent()).findClassOrPackageAtFirst();
    }

    private boolean isMethodCallRef() {
        PsiElement parent = this.getParent();
        return parent instanceof GrMethodCall || parent instanceof GrReferenceExpressionImpl && ((GrReferenceExpressionImpl)parent).isMethodCallRef();
    }

    private boolean isDefinitelyKeyOfMap() {
        PsiElement resolved;
        GrExpression qualifier = ResolveUtil.getSelfOrWithQualifier(this);
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
            return false;
        }
        PsiType type = qualifier.getType();
        if (type == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
            return false;
        }
        String qname = TypesUtil.getQualifiedName(type);
        if (qname != null) {
            if (qname.startsWith("java.")) {
                return true;
            }
            if ("groovy.util.ConfigObject".equals(qname)) {
                return false;
            }
            if (qname.startsWith("groovy.")) {
                return true;
            }
        }
        return false;
    }

    private GroovyResolveResult[] resolveTypeOrProperty() {
        if (this.isDefinitelyKeyOfMap()) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] results = this.resolveTypeOrPropertyInner();
        if (results.length == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (!ResolveUtil.mayBeKeyOfMap(this)) {
            return results;
        }
        ArrayList<GroovyResolveResult> filtered = new ArrayList<GroovyResolveResult>();
        for (GroovyResolveResult result : results) {
            String name;
            PsiClass containingClass;
            PsiElement element = result.getElement();
            if (element instanceof PsiMember && (((PsiMember)element).hasModifierProperty("private") || (containingClass = ((PsiMember)element).getContainingClass()) != null && (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Map") || (name = containingClass.getQualifiedName()) != null && name.startsWith("java.") || containingClass.getLanguage() != GroovyLanguage.INSTANCE && !InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"groovy.lang.GroovyObject")))) continue;
            filtered.add(result);
        }
        return (GroovyResolveResult[])ContainerUtil.toArray(filtered, (Object[])new GroovyResolveResult[filtered.size()]);
    }

    private GroovyResolveResult[] resolveTypeOrPropertyInner() {
        GroovyResolveResult[] results;
        PsiElement nameElement = this.getReferenceNameElement();
        String name = this.getReferenceName();
        if (name == null || nameElement == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        IElementType nameType = nameElement.getNode().getElementType();
        if (nameType == GroovyTokenTypes.kTHIS ? (results = GrThisReferenceResolver.resolveThisExpression(this)) != null : nameType == GroovyTokenTypes.kSUPER && (results = GrSuperReferenceResolver.resolveSuperExpression(this)) != null) {
            return results;
        }
        EnumSet<ClassHint.ResolveKind> kinds = this.getParent() instanceof GrReferenceExpression ? ClassHint.RESOLVE_KINDS_CLASS_PACKAGE : ClassHint.RESOLVE_KINDS_CLASS;
        GroovyResolveResult[] classCandidates = null;
        GrReferenceResolveRunner resolveRunner = new GrReferenceResolveRunner(this);
        PropertyResolverProcessor processor = new PropertyResolverProcessor(name, this);
        resolveRunner.resolveImpl(processor);
        Object[] fieldCandidates = ((ResolverProcessor)processor).getCandidates();
        if (this.hasAt()) {
            return fieldCandidates;
        }
        boolean canBeClassOrPackage = ResolveUtil.canBeClassOrPackage(this);
        if (canBeClassOrPackage && this.findClassOrPackageAtFirst()) {
            ClassResolverProcessor classProcessor = new ClassResolverProcessor(name, this, kinds);
            resolveRunner.resolveImpl(classProcessor);
            classCandidates = classProcessor.getCandidates();
            if (classCandidates.length > 0 && GrReferenceExpressionImpl.containsPackage(classCandidates)) {
                return classCandidates;
            }
        }
        for (GroovyResolveResult groovyResolveResult : fieldCandidates) {
            PsiClass containingClass;
            PsiElement element = groovyResolveResult.getElement();
            if (!(element instanceof PsiField ? (containingClass = ((PsiField)element).getContainingClass()) != null && PsiUtil.getContextClass(this) == containingClass : !(element instanceof GrBindingVariable))) continue;
            return fieldCandidates;
        }
        if (classCandidates != null && classCandidates.length > 0) {
            return classCandidates;
        }
        boolean isLValue = PsiUtil.isLValue(this);
        String[] accessorNames = isLValue ? GroovyPropertyUtils.suggestSettersName(name) : GroovyPropertyUtils.suggestGettersName(name);
        ArrayList accessorResults = new ArrayList();
        for (String accessorName : accessorNames) {
            AccessorResolverProcessor accessorResolver = new AccessorResolverProcessor(accessorName, name, this, !isLValue, false, PsiImplUtil.getQualifierType(this), this.getTypeArguments());
            resolveRunner.resolveImpl(accessorResolver);
            Object[] candidates = accessorResolver.getCandidates();
            if (candidates.length == 1 && candidates[0].isStaticsOK() && candidates[0].isAccessible()) {
                return candidates;
            }
            ContainerUtil.addAll(accessorResults, (Object[])candidates);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])fieldCandidates);
        GrReferenceExpressionImpl.filterOutBindings(arrayList);
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new GroovyResolveResult[arrayList.size()]);
        }
        if (classCandidates == null && canBeClassOrPackage) {
            ClassResolverProcessor classProcessor = new ClassResolverProcessor(name, this, kinds);
            resolveRunner.resolveImpl(classProcessor);
            classCandidates = classProcessor.getCandidates();
        }
        if (classCandidates != null && classCandidates.length > 0) {
            return classCandidates;
        }
        if (!accessorResults.isEmpty()) {
            return new GroovyResolveResult[]{(GroovyResolveResult)accessorResults.get(0)};
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static boolean containsPackage(GroovyResolveResult[] candidates) {
        for (GroovyResolveResult candidate : candidates) {
            if (!(candidate.getElement() instanceof PsiPackage)) continue;
            return true;
        }
        return false;
    }

    public GroovyResolveResult[] getCallVariants(GrExpression upToArgument) {
        return this.resolveMethodOrProperty(true, upToArgument, true);
    }

    private void processMethods(MethodResolverProcessor methodResolver) {
        new GrReferenceResolveRunner(this).resolveImpl(methodResolver);
        if (methodResolver.hasApplicableCandidates()) {
            return;
        }
        if (!this.isQualified() && this.getContext() instanceof GrMethodCall) {
            ClosureMissingMethodContributor.processMethodsFromClosures(this, methodResolver);
        }
    }

    private GroovyResolveResult[] resolveMethodOrProperty(boolean allVariants, GrExpression upToArgument, boolean genericsMatter) {
        String name = this.getReferenceName();
        if (name == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GrReferenceResolveRunner resolveRunner = new GrReferenceResolveRunner(this);
        PropertyResolverProcessor propertyResolver = new PropertyResolverProcessor(name, this);
        resolveRunner.resolveImpl(propertyResolver);
        Object[] propertyCandidates = propertyResolver.getCandidates();
        if (!allVariants) {
            for (GroovyResolveResult groovyResolveResult : propertyCandidates) {
                PsiElement element = groovyResolveResult.getElement();
                if (!(element instanceof GrVariable) || element instanceof GrField || element instanceof GrBindingVariable) continue;
                return propertyCandidates;
            }
        }
        Pair<Boolean, GroovyResolveResult[]> shapeResults = this.resolveByShape(allVariants, upToArgument);
        if (!genericsMatter && !allVariants && ((Boolean)shapeResults.first).booleanValue()) {
            GrReferenceExpressionImpl.assertAllAreValid((GroovyResolveResult[])shapeResults.second);
            return (GroovyResolveResult[])shapeResults.second;
        }
        MethodResolverProcessor methodResolver = null;
        if (genericsMatter) {
            methodResolver = this.createMethodProcessor(allVariants, name, false, upToArgument);
            for (GroovyResolveResult result : (GroovyResolveResult[])shapeResults.second) {
                ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result.getSubstitutor()).put(ClassHint.RESOLVE_CONTEXT, (Object)result.getCurrentFileResolveContext()).put(SpreadState.SPREAD_STATE, (Object)result.getSpreadState());
                PsiElement element = result.getElement();
                assert (element != null);
                methodResolver.execute(element, state);
            }
            if (!allVariants && methodResolver.hasApplicableCandidates()) {
                return methodResolver.getCandidates();
            }
        }
        if (!allVariants) {
            for (Object candidate : propertyCandidates) {
                PsiClass containingClass;
                PsiElement element = candidate.getElement();
                if (!(element instanceof GrField) || (containingClass = ((PsiField)element).getContainingClass()) == null || !PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)this, (boolean)true)) continue;
                return propertyCandidates;
            }
        }
        ArrayList<GroovyResolveResult> allCandidates = new ArrayList<GroovyResolveResult>();
        ContainerUtil.addAll(allCandidates, (Object[])propertyCandidates);
        ContainerUtil.addAll(allCandidates, (Object[])(genericsMatter ? methodResolver.getCandidates() : (GroovyResolveResult[])shapeResults.second));
        GrReferenceExpressionImpl.filterOutBindings(allCandidates);
        for (String getterName : GroovyPropertyUtils.suggestGettersName(name)) {
            AccessorResolverProcessor getterResolver = new AccessorResolverProcessor(getterName, name, this, true, genericsMatter, PsiImplUtil.getQualifierType(this), this.getTypeArguments());
            resolveRunner.resolveImpl(getterResolver);
            Object[] candidates = getterResolver.getCandidates();
            if (!allVariants && candidates.length == 1) {
                return candidates;
            }
            ContainerUtil.addAll(allCandidates, (Object[])candidates);
        }
        if (!allCandidates.isEmpty()) {
            return allCandidates.toArray(new GroovyResolveResult[allCandidates.size()]);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static void filterOutBindings(List<GroovyResolveResult> candidates) {
        boolean hasNonBinding = false;
        for (GroovyResolveResult candidate : candidates) {
            if (candidate.getElement() instanceof GrBindingVariable) continue;
            hasNonBinding = true;
        }
        if (hasNonBinding) {
            Iterator<GroovyResolveResult> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                GroovyResolveResult candidate;
                candidate = iterator.next();
                if (!(candidate.getElement() instanceof GrBindingVariable)) continue;
                iterator.remove();
            }
        }
    }

    private Pair<Boolean, GroovyResolveResult[]> resolveByShape(boolean allVariants, GrExpression upToArgument) {
        if (allVariants) {
            return this.doResolveByShape(true, upToArgument);
        }
        LOG.assertTrue(upToArgument == null);
        return (Pair)TypeInferenceHelper.getCurrentContext().getCachedValue(this, new NullableComputable<Pair<Boolean, GroovyResolveResult[]>>(){

            public Pair<Boolean, GroovyResolveResult[]> compute() {
                return GrReferenceExpressionImpl.this.doResolveByShape(false, null);
            }
        });
    }

    private Pair<Boolean, GroovyResolveResult[]> doResolveByShape(boolean allVariants, GrExpression upToArgument) {
        String name = this.getReferenceName();
        LOG.assertTrue(name != null);
        MethodResolverProcessor shapeProcessor = this.createMethodProcessor(allVariants, name, true, upToArgument);
        this.processMethods(shapeProcessor);
        GroovyResolveResult[] candidates = shapeProcessor.getCandidates();
        GrReferenceExpressionImpl.assertAllAreValid(candidates);
        return Pair.create((Object)shapeProcessor.hasApplicableCandidates(), (Object)candidates);
    }

    private static void assertAllAreValid(GroovyResolveResult[] candidates) {
        for (GroovyResolveResult candidate : candidates) {
            PsiElement element = candidate.getElement();
            LOG.assertTrue(element == null || element.isValid());
        }
    }

    private MethodResolverProcessor createMethodProcessor(boolean allVariants, String name, boolean byShape, GrExpression upToArgument) {
        PsiType[] argTypes = PsiUtil.getArgumentTypes(this, false, upToArgument, byShape);
        if (byShape && argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = TypeConversionUtil.erasure((PsiType)argTypes[i]);
            }
        }
        PsiType qualifierType = PsiImplUtil.getQualifierType(this);
        return new MethodResolverProcessor(name, this, false, qualifierType, argTypes, this.getTypeArguments(), allVariants, byShape);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitReferenceExpression(this);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        ASTNode lastChild = this.getNode().getLastChildNode();
        if (lastChild == null) {
            return null;
        }
        if (TokenSets.REFERENCE_NAMES.contains(lastChild.getElementType())) {
            return lastChild.getPsi();
        }
        return null;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public GrExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            Object value;
            IElementType nodeType = nameElement.getNode().getElementType();
            if (TokenSets.STRING_LITERAL_SET.contains(nodeType) && (value = GrLiteralImpl.getLiteralValue(nameElement)) instanceof String) {
                return (String)value;
            }
            return nameElement.getText();
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name;
        GroovyResolveResult result = this.advancedResolve();
        if (result.isInvokedOnProperty() && (name = GroovyPropertyUtils.getPropertyNameByAccessorName(newElementName)) != null) {
            newElementName = name;
        }
        if (PsiUtil.isThisOrSuperRef(this)) {
            return this;
        }
        return this.handleElementRenameSimple(newElementName);
    }

    protected GrReferenceExpression bindWithQualifiedRef(String qName) {
        GrReferenceExpression qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceExpressionFromText(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public boolean isFullyQualified() {
        if (this.getKind() == Kind.TYPE_OR_PROPERTY && this.resolve() instanceof PsiPackage) {
            return true;
        }
        GrExpression qualifier = this.getQualifier();
        if (!(qualifier instanceof GrReferenceExpressionImpl)) {
            return false;
        }
        return ((GrReferenceExpressionImpl)qualifier).isFullyQualified();
    }

    @Override
    public PsiElement handleElementRenameSimple(String newElementName) throws IncorrectOperationException {
        if (!PsiUtil.isValidReferenceName(newElementName)) {
            PsiElement old = this.getReferenceNameElement();
            if (old == null) {
                throw new IncorrectOperationException("ref has no name element");
            }
            PsiElement element = GroovyPsiElementFactory.getInstance(this.getProject()).createStringLiteralForReference(newElementName);
            old.replace(element);
            return this;
        }
        return super.handleElementRenameSimple(newElementName);
    }

    public String toString() {
        return "Reference expression";
    }

    @Override
    public PsiElement resolve() {
        GroovyResolveResult[] results = this.resolveByShape();
        return results.length == 1 ? results[0].getElement() : null;
    }

    @Override
    public GroovyResolveResult[] resolveByShape() {
        final InferenceContext context = TypeInferenceHelper.getCurrentContext();
        return context.getCachedValue(this, new Computable<GroovyResolveResult[]>(){

            public GroovyResolveResult[] compute() {
                Pair key = Pair.create((Object)GrReferenceExpressionImpl.this, (Object)context);
                GroovyResolveResult[] value = (GroovyResolveResult[])RecursionManager.doPreventingRecursion((Object)key, (boolean)true, (Computable)new Computable<GroovyResolveResult[]>(){

                    public GroovyResolveResult[] compute() {
                        return GrReferenceExpressionImpl.this.doPolyResolve(false, false);
                    }
                });
                return value == null ? GroovyResolveResult.EMPTY_ARRAY : value;
            }
        });
    }

    @Override
    public PsiType getNominalType() {
        PsiType type;
        GroovyResolveResult resolveResult = this.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        for (GrReferenceTypeEnhancer enhancer : (GrReferenceTypeEnhancer[])GrReferenceTypeEnhancer.EP_NAME.getExtensions()) {
            PsiType type2 = enhancer.getReferenceType(this, resolved);
            if (type2 == null) continue;
            return type2;
        }
        IElementType dotType = this.getDotTokenType();
        if (dotType == GroovyTokenTypes.mMEMBER_POINTER) {
            return GrClosureType.create(this.multiResolve(false), this);
        }
        if (this.isDefinitelyKeyOfMap() && (type = GrReferenceExpressionImpl.getTypeFromMapAccess(this)) != null) {
            return type;
        }
        PsiType result = this.getNominalTypeInner(resolved);
        if (result == null) {
            return null;
        }
        result = TypesUtil.substituteAndNormalizeType(result, resolveResult.getSubstitutor(), resolveResult.getSpreadState(), this);
        return result;
    }

    private PsiType getNominalTypeInner(PsiElement resolved) {
        if (resolved == null && !"class".equals(this.getReferenceName())) {
            resolved = this.resolve();
        }
        if (resolved instanceof PsiClass) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (PsiUtil.isInstanceThisRef(this)) {
                PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)resolved);
                if (categoryType != null) {
                    return categoryType;
                }
                return factory.createType((PsiClass)resolved);
            }
            if (PsiUtil.isSuperReference(this)) {
                PsiClass contextClass = PsiUtil.getContextClass(this);
                if (GrTraitUtil.isTrait(contextClass)) {
                    Object[] extendsTypes = contextClass.getExtendsListTypes();
                    Object[] implementsTypes = contextClass.getImplementsListTypes();
                    Object[] superTypes = (PsiClassType[])ArrayUtil.mergeArrays((Object[])implementsTypes, (Object[])extendsTypes, (ArrayFactory)PsiClassType.ARRAY_FACTORY);
                    return PsiIntersectionType.createIntersection((PsiType[])((PsiType[])ArrayUtil.reverseArray((Object[])superTypes)));
                }
                return factory.createType((PsiClass)resolved);
            }
            if (this.getParent() instanceof GrReferenceExpression) {
                return factory.createType((PsiClass)resolved);
            }
            return TypesUtil.createJavaLangClassType((PsiType)factory.createType((PsiClass)resolved), this.getProject(), this.getResolveScope());
        }
        if (resolved instanceof GrVariable) {
            return ((GrVariable)resolved).getDeclaredType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (PropertyUtil.isSimplePropertySetter((PsiMethod)method) && !method.getName().equals(this.getReferenceName())) {
                return method.getParameterList().getParameters()[0].getType();
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && "getClass".equals(method.getName())) {
                return TypesUtil.createJavaLangClassType(PsiImplUtil.getQualifierType(this), this.getProject(), this.getResolveScope());
            }
            return PsiUtil.getSmartReturnType(method);
        }
        if (resolved == null) {
            PsiType fromClassRef = GrReferenceExpressionImpl.getTypeFromClassRef(this);
            if (fromClassRef != null) {
                return fromClassRef;
            }
            PsiType fromMapAccess = GrReferenceExpressionImpl.getTypeFromMapAccess(this);
            if (fromMapAccess != null) {
                return fromMapAccess;
            }
            PsiType fromSpreadOperator = GrReferenceExpressionImpl.getTypeFromSpreadOperator(this);
            if (fromSpreadOperator != null) {
                return fromSpreadOperator;
            }
        }
        return null;
    }

    private static PsiType getTypeFromMapAccess(GrReferenceExpressionImpl ref) {
        PsiType substituted;
        PsiSubstitutor substitutor;
        PsiClass mapClass;
        PsiClassType.ClassResolveResult qResult;
        PsiClass clazz;
        PsiType qType;
        GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null && (qType = qualifier.getNominalType()) instanceof PsiClassType && (clazz = (qResult = ((PsiClassType)qType).resolveGenerics()).getElement()) != null && (mapClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("java.util.Map", ref.getResolveScope())) != null && mapClass.getTypeParameters().length == 2 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)mapClass, (PsiClass)clazz, (PsiSubstitutor)qResult.getSubstitutor())) != null && (substituted = substitutor.substitute(mapClass.getTypeParameters()[1])) != null) {
            return PsiImplUtil.normalizeWildcardTypeByPosition(substituted, ref);
        }
        return null;
    }

    private static PsiType getTypeFromSpreadOperator(GrReferenceExpressionImpl ref) {
        if (ref.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return TypesUtil.createType("java.util.List", ref);
        }
        return null;
    }

    private static PsiType getTypeFromClassRef(GrReferenceExpressionImpl ref) {
        if ("class".equals(ref.getReferenceName())) {
            return TypesUtil.createJavaLangClassType(PsiImplUtil.getQualifierType(ref), ref.getProject(), ref.getResolveScope());
        }
        return null;
    }

    private static PsiType getInferredTypes(GrReferenceExpressionImpl refExpr, PsiElement resolved) {
        PsiType mapValueType;
        PsiType qType;
        GrExpression qualifier = refExpr.getQualifier();
        if (qualifier == null && !(resolved instanceof PsiClass) && !(resolved instanceof PsiPackage)) {
            return TypeInferenceHelper.getCurrentContext().getVariableType(refExpr);
        }
        if (qualifier != null && (qType = qualifier.getType()) instanceof PsiClassType && !(qType instanceof GrMapType) && (mapValueType = GrReferenceExpressionImpl.getTypeFromMapAccess(refExpr)) != null) {
            return mapValueType;
        }
        return null;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    public GrExpression replaceWithExpression(GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroovyResolveResult[] doPolyResolve(boolean incompleteCode, boolean genericsMatter) {
        GroovyResolveResult[] processor;
        String name = this.getReferenceName();
        if (name == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (incompleteCode) {
            processor = CompletionProcessor.createRefSameNameProcessor(this, name);
            new GrReferenceResolveRunner(this).resolveImpl((ResolverProcessor)processor);
            GroovyResolveResult[] propertyCandidates = processor.getCandidates();
            if (propertyCandidates.length > 0 && !PsiUtil.isSingleBindingVariant(propertyCandidates)) {
                return propertyCandidates;
            }
        }
        try {
            GroovyResolveResult[] groovyResolveResultArray;
            ResolveProfiler.start();
            switch (this.getKind()) {
                case METHOD_OR_PROPERTY: {
                    processor = this.resolveMethodOrProperty(false, null, genericsMatter);
                    return processor;
                }
                case TYPE_OR_PROPERTY: {
                    processor = this.resolveTypeOrProperty();
                    return processor;
                }
                case METHOD_OR_PROPERTY_OR_TYPE: {
                    GroovyResolveResult[] results = this.resolveMethodOrProperty(false, null, genericsMatter);
                    if (results.length == 0) {
                        results = this.resolveTypeOrProperty();
                    }
                    groovyResolveResultArray = results;
                    return groovyResolveResultArray;
                }
            }
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            return groovyResolveResultArray;
        }
        finally {
            long time = ResolveProfiler.finish();
            ResolveProfiler.write("ref " + this.getText() + " " + this.hashCode() + " : " + time);
        }
    }

    private Kind getKind() {
        if (this.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER) {
            return Kind.METHOD_OR_PROPERTY;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrMethodCallExpression || parent instanceof GrApplicationStatement) {
            return Kind.METHOD_OR_PROPERTY_OR_TYPE;
        }
        return Kind.TYPE_OR_PROPERTY;
    }

    public String getCanonicalText() {
        return this.getRangeInElement().substring(this.getElement().getText());
    }

    @Override
    public boolean hasAt() {
        return this.findChildByType(GroovyTokenTypes.mAT) != null;
    }

    @Override
    public boolean hasMemberPointer() {
        return this.findChildByType(GroovyTokenTypes.mMEMBER_POINTER) != null;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiMethod[] superMethods;
        PsiElement baseTarget = this.resolve();
        if (this.getManager().areElementsEquivalent(element, baseTarget)) {
            return true;
        }
        PsiElement target = GroovyTargetElementEvaluator.correctSearchTargets(baseTarget);
        if (target != baseTarget && this.getManager().areElementsEquivalent(element, target)) {
            return true;
        }
        return element instanceof PsiMethod && target instanceof PsiMethod && Arrays.asList(superMethods = ((PsiMethod)target).findSuperMethods(false)).contains(element);
    }

    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public GrExpression getQualifierExpression() {
        return GrReferenceExpressionImpl.findExpressionChild(this);
    }

    @Override
    public PsiElement getDotToken() {
        return this.findChildByType(TokenSets.DOTS);
    }

    @Override
    public void replaceDotToken(PsiElement newDot) {
        if (newDot == null) {
            return;
        }
        if (!TokenSets.DOTS.contains(newDot.getNode().getElementType())) {
            return;
        }
        PsiElement oldDot = this.getDotToken();
        if (oldDot == null) {
            return;
        }
        this.getNode().replaceChild(oldDot.getNode(), newDot.getNode());
    }

    @Override
    public IElementType getDotTokenType() {
        PsiElement dot = this.getDotToken();
        return dot == null ? null : dot.getNode().getElementType();
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, false, POLY_RESOLVER);
        return results.length == 1 ? results[0] : GroovyResolveResult.EMPTY_RESULT;
    }

    @Override
    public GroovyResolveResult[] multiResolve(boolean incomplete) {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, incomplete, POLY_RESOLVER);
        return results.length == 0 ? GroovyResolveResult.EMPTY_ARRAY : results;
    }

    @Override
    public GroovyResolveResult[] getSameNameVariants() {
        return this.doPolyResolve(true, true);
    }

    @Override
    public GrReferenceExpression bindToElementViaStaticImport(PsiMember member) {
        if (this.getQualifier() != null) {
            throw new IncorrectOperationException("Reference has qualifier");
        }
        if (StringUtil.isEmpty((String)this.getReferenceName())) {
            throw new IncorrectOperationException("Reference has empty name");
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException("Member has no containing class");
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFile) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String text = "import static " + containingClass.getQualifiedName() + "." + member.getName();
            GrImportStatement statement = factory.createImportStatementFromText(text);
            ((GroovyFile)file).addImport(statement);
        }
        return this;
    }

    static enum Kind {
        TYPE_OR_PROPERTY,
        METHOD_OR_PROPERTY,
        METHOD_OR_PROPERTY_OR_TYPE;

    }

    private static final class OurTypesCalculator
    implements Function<GrReferenceExpressionImpl, PsiType> {
        private OurTypesCalculator() {
        }

        public PsiType fun(GrReferenceExpressionImpl refExpr) {
            GroovyResolveResult resolveResult;
            PsiElement resolvedF;
            Object type;
            if (ResolveUtil.isClassReference(refExpr)) {
                GrExpression qualifier = refExpr.getQualifier();
                LOG.assertTrue(qualifier != null);
                return TypesUtil.createJavaLangClassType(qualifier.getType(), refExpr.getProject(), refExpr.getResolveScope());
            }
            if (PsiUtil.isCompileStatic(refExpr) && (type = (resolvedF = (resolveResult = refExpr.advancedResolve()).getElement()) instanceof GrField ? ((GrField)resolvedF).getType() : (resolvedF instanceof GrAccessorMethod ? ((GrAccessorMethod)resolvedF).getProperty().getType() : null)) != null) {
                return resolveResult.getSubstitutor().substitute(type);
            }
            PsiElement resolved = refExpr.resolve();
            PsiType nominal = refExpr.getNominalType();
            Boolean reassigned = GrReassignedLocalVarsChecker.isReassignedVar(refExpr);
            if (reassigned != null && reassigned.booleanValue()) {
                return GrReassignedLocalVarsChecker.getReassignedVarType(refExpr, true);
            }
            PsiType inferred = GrReferenceExpressionImpl.getInferredTypes(refExpr, resolved);
            if (inferred == null) {
                if (nominal == null && resolved instanceof GrVariable) {
                    LOG.assertTrue(resolved.isValid());
                    return ((GrVariable)resolved).getTypeGroovy();
                }
                return nominal;
            }
            if (nominal == null) {
                return inferred;
            }
            if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)nominal), (PsiType)inferred, (boolean)false) && resolved instanceof GrVariable && ((GrVariable)resolved).getTypeElementGroovy() != null) {
                return nominal;
            }
            return inferred;
        }
    }
}

