/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionTypeCalculators;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryFacade;

public abstract class GrBinaryExpressionImpl
extends GrExpressionImpl
implements GrBinaryExpression {
    private static final ResolveCache.PolyVariantResolver<GrBinaryExpressionImpl> RESOLVER = new ResolveCache.PolyVariantResolver<GrBinaryExpressionImpl>(){

        private List<GroovyResolveResult[]> resolveSubExpressions(GrBinaryExpression expression, boolean incompleteCode) {
            SmartList subExpressions = new SmartList();
            expression.getLeftOperand().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)subExpressions, incompleteCode){
                final /* synthetic */ List val$subExpressions;
                final /* synthetic */ boolean val$incompleteCode;
                {
                    this.val$subExpressions = list;
                    this.val$incompleteCode = bl;
                }

                public void visitElement(PsiElement element) {
                    if (element instanceof GrBinaryExpression) {
                        super.visitElement(element);
                    }
                }

                protected void elementFinished(PsiElement element) {
                    if (element instanceof GrBinaryExpressionImpl) {
                        this.val$subExpressions.add(((GrBinaryExpressionImpl)element).multiResolve(this.val$incompleteCode));
                    }
                }
            });
            return subExpressions;
        }

        public GroovyResolveResult[] resolve(GrBinaryExpressionImpl binary, boolean incompleteCode) {
            List<GroovyResolveResult[]> subExpressions = this.resolveSubExpressions(binary, incompleteCode);
            IElementType opType = binary.getOperationTokenType();
            PsiType lType = binary.getLeftType();
            if (lType == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            PsiType rType = binary.getRightType();
            subExpressions.clear();
            return TypesUtil.getOverloadedOperatorCandidates(lType, opType, binary, new PsiType[]{rType}, incompleteCode);
        }
    };
    private static final Function<GrBinaryExpressionImpl, PsiType> TYPE_CALCULATOR = new Function<GrBinaryExpressionImpl, PsiType>(){

        public PsiType fun(GrBinaryExpressionImpl expression) {
            return (PsiType)GrBinaryExpressionTypeCalculators.getTypeCalculator(expression.getFacade()).fun((Object)expression.getFacade());
        }
    };
    private final GrBinaryFacade myFacade = new GrBinaryFacade(){

        @Override
        public GrExpression getLeftOperand() {
            return GrBinaryExpressionImpl.this.getLeftOperand();
        }

        @Override
        public GrExpression getRightOperand() {
            return GrBinaryExpressionImpl.this.getRightOperand();
        }

        @Override
        public IElementType getOperationTokenType() {
            return GrBinaryExpressionImpl.this.getOperationTokenType();
        }

        @Override
        public PsiElement getOperationToken() {
            return GrBinaryExpressionImpl.this.getOperationToken();
        }

        @Override
        public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
            return GrBinaryExpressionImpl.this.multiResolve(incompleteCode);
        }

        @Override
        public GrExpression getPsiElement() {
            return GrBinaryExpressionImpl.this;
        }
    };

    protected PsiType getRightType() {
        GrExpression rightOperand = this.getRightOperand();
        return rightOperand == null ? null : rightOperand.getType();
    }

    protected PsiType getLeftType() {
        return this.getLeftOperand().getType();
    }

    public GrBinaryExpressionImpl(ASTNode node) {
        super(node);
    }

    @Override
    public GrExpression getLeftOperand() {
        return (GrExpression)this.findNotNullChildByClass(GrExpression.class);
    }

    @Override
    public GrExpression getRightOperand() {
        PsiElement last = this.getLastChild();
        return last instanceof GrExpression ? (GrExpression)last : null;
    }

    @Override
    public IElementType getOperationTokenType() {
        PsiElement child = this.getOperationToken();
        ASTNode node = child.getNode();
        assert (node != null);
        return node.getElementType();
    }

    @Override
    public PsiElement getOperationToken() {
        return this.findNotNullChildByType(TokenSets.BINARY_OP_SET);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement token = this.getOperationToken();
        int offset = token.getStartOffsetInParent();
        return new TextRange(offset, offset + token.getTextLength());
    }

    public PsiElement resolve() {
        return PsiImplUtil.extractUniqueElement(this.multiResolve(false));
    }

    public String getCanonicalText() {
        return this.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("binary expression cannot be renamed");
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("binary expression cannot be bound to anything");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiReference getReference() {
        return this;
    }

    private GrBinaryFacade getFacade() {
        return this.myFacade;
    }
}

