/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class ClassUtil {
    private static final LightCacheKey<Map<String, PsiClass>> PARENT_CACHE_KEY = LightCacheKey.create();

    public static Map<String, PsiClass> getSuperClassesWithCache(PsiClass aClass) {
        Map<String, PsiClass> superClassNames = PARENT_CACHE_KEY.getCachedValue((PsiElement)aClass);
        if (superClassNames == null) {
            THashSet superClasses = new THashSet();
            superClasses.add(aClass);
            InheritanceUtil.getSuperClasses((PsiClass)aClass, (Set)superClasses, (boolean)true);
            superClassNames = new LinkedHashMap<String, PsiClass>();
            for (PsiClass superClass : superClasses) {
                superClassNames.put(superClass.getQualifiedName(), superClass);
            }
            superClassNames = PARENT_CACHE_KEY.putCachedValue((PsiElement)aClass, superClassNames);
        }
        return superClassNames;
    }

    public static PsiType findPsiType(GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        String typeText = descriptor.getTypeText();
        String key = ClassUtil.getClassKey(typeText);
        Object cached = ctx.get((Object)key);
        if (cached instanceof PsiType) {
            return (PsiType)cached;
        }
        PsiType found = JavaPsiFacade.getElementFactory((Project)descriptor.getProject()).createTypeFromText(typeText, (PsiElement)descriptor.getPlaceFile());
        ctx.put((Object)key, (Object)found);
        return found;
    }

    public static String getClassKey(String fqName) {
        return "Class: " + fqName;
    }
}

