/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GrVariableDeclarationImpl
extends GrStubElementBase<EmptyStub>
implements GrVariableDeclaration,
StubBasedPsiElement<EmptyStub> {
    private static final Logger LOG = Logger.getInstance(GrVariableDeclarationImpl.class);

    public GrVariableDeclarationImpl(ASTNode node) {
        super(node);
    }

    public GrVariableDeclarationImpl(EmptyStub stub) {
        super(stub, (IStubElementType)GroovyElementTypes.VARIABLE_DEFINITION);
    }

    @Override
    public PsiElement getParent() {
        return this.getDefinitionParent();
    }

    @Override
    public <T extends GrStatement> T replaceWithStatement(T statement) {
        return GroovyPsiElementImpl.replaceWithStatement(this, statement);
    }

    @Override
    public void removeStatement() throws IncorrectOperationException {
        GroovyPsiElementImpl.removeStatement(this);
    }

    @Override
    public GrModifierList getModifierList() {
        return (GrModifierList)this.getRequiredStubOrPsiChild(GroovyElementTypes.MODIFIERS);
    }

    @Override
    public boolean hasModifierProperty(String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public void setType(PsiType type) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (type == null) {
            if (typeElement == null) {
                return;
            }
            if (this.getModifierList().getModifiers().length == 0) {
                this.getModifierList().setModifierProperty("def", true);
            }
            typeElement.delete();
            return;
        }
        type = TypesUtil.unboxPrimitiveTypeWrapper(type);
        try {
            newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (typeElement == null) {
            this.getModifierList().setModifierProperty("def", false);
            GrVariable[] variables = this.getVariables();
            if (variables.length == 0) {
                return;
            }
            newTypeElement = (GrTypeElement)this.addBefore(newTypeElement, variables[0]);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(newTypeElement);
        }
        JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)newTypeElement);
    }

    @Override
    public boolean isTuple() {
        return this.findChildByType(GroovyTokenTypes.mLPAREN) != null;
    }

    @Override
    public GrExpression getTupleInitializer() {
        return GroovyPsiElementImpl.findExpressionChild(this);
    }

    public void deleteChildInternal(ASTNode child) {
        PsiElement psi = child.getPsi();
        if (psi == this.getTupleInitializer()) {
            this.deleteChildInternal(this.findNotNullChildByType(GroovyTokenTypes.mASSIGN).getNode());
        }
        super.deleteChildInternal(child);
    }

    @Override
    public GrTypeElement getTypeElementGroovyForVariable(GrVariable var) {
        if (this.isTuple()) {
            PsiElement psiElement = PsiUtil.skipWhitespacesAndComments(var.getPrevSibling(), false);
            if (psiElement instanceof GrTypeElement) {
                return (GrTypeElement)psiElement;
            }
            return null;
        }
        return this.getTypeElementGroovy();
    }

    @Override
    public GrTypeElement getTypeElementGroovy() {
        if (this.isTuple()) {
            return null;
        }
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitVariableDeclaration(this);
    }

    public String toString() {
        return "Variable definitions";
    }

    @Override
    public GrMember[] getMembers() {
        ArrayList<GrMember> result = new ArrayList<GrMember>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrMember)) continue;
            result.add((GrMember)cur);
        }
        return result.toArray(new GrMember[result.size()]);
    }

    @Override
    public GrVariable[] getVariables() {
        return (GrVariable[])this.getStubOrPsiChildren(TokenSets.VARIABLES, GrVariable.ARRAY_FACTORY);
    }

    public boolean processDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!ResolveUtil.shouldProcessProperties((ClassHint)processor.getHint(ClassHint.KEY))) {
            return true;
        }
        if (lastParent != null && !(this.getParent() instanceof GrTypeDefinitionBody) && lastParent == this.getTupleInitializer()) {
            return true;
        }
        for (GrVariable variable : this.getVariables()) {
            if (lastParent == variable || lastParent instanceof GrMethod && !(variable instanceof GrField)) break;
            if (ResolveUtil.processElement(processor, variable, state)) continue;
            return false;
        }
        return true;
    }

    public PsiReference getReference() {
        if (this.getTypeElementGroovy() != null) {
            return null;
        }
        TextRange range = this.getRangeForReference();
        if (range == null) {
            return null;
        }
        return new GrTypeReference(range);
    }

    private TextRange getRangeForReference() {
        PsiElement modifier = this.findSuitableModifier();
        if (modifier == null) {
            return null;
        }
        return modifier.getTextRange().shiftRight(-this.getTextRange().getStartOffset());
    }

    private PsiElement findSuitableModifier() {
        GrModifierList list = this.getModifierList();
        PsiElement defModifier = PsiUtil.findModifierInList(list, "def");
        if (defModifier != null) {
            return defModifier;
        }
        PsiElement finalModifier = PsiUtil.findModifierInList(list, "final");
        if (finalModifier != null) {
            return finalModifier;
        }
        for (PsiElement element : list.getModifiers()) {
            if (element instanceof GrAnnotation) continue;
            return element;
        }
        return null;
    }

    private class GrTypeReference
    extends PsiReferenceBase<GrVariableDeclaration> {
        public GrTypeReference(TextRange range) {
            super((PsiElement)GrVariableDeclarationImpl.this, range, true);
        }

        public PsiElement resolve() {
            GrVariable[] variables = GrVariableDeclarationImpl.this.getVariables();
            if (variables.length == 0) {
                return null;
            }
            GrVariable resolved = variables[0];
            PsiType typeGroovy = resolved.getTypeGroovy();
            if (typeGroovy instanceof PsiClassType) {
                return ((PsiClassType)typeGroovy).resolve();
            }
            return resolved;
        }

        public Object[] getVariants() {
            return EMPTY_ARRAY;
        }

        public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
            return this.getElement();
        }
    }
}

