/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrLabeledStatementImpl
extends GroovyPsiElementImpl
implements GrLabeledStatement {
    public GrLabeledStatementImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitLabeledStatement(this);
    }

    public String toString() {
        return "Labeled statement";
    }

    public String getLabelName() {
        return this.getName();
    }

    @Override
    public PsiElement getLabel() {
        PsiElement label = this.findChildByType(GroovyTokenTypes.mIDENT);
        assert (label != null);
        return label;
    }

    @Override
    public GrStatement getStatement() {
        return (GrStatement)this.findChildByClass(GrStatement.class);
    }

    public boolean processDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        GrStatement statement = this.getStatement();
        return statement == null || statement == lastParent || statement.processDeclarations(processor, state, lastParent, place);
    }

    public SearchScope getUseScope() {
        return new LocalSearchScope((PsiElement)this);
    }

    public PsiElement setName(String name) throws IncorrectOperationException {
        PsiElement labelElement = this.getLabel();
        PsiElement newLabel = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(name);
        labelElement.replace(newLabel);
        return this;
    }

    @Override
    public String getName() {
        PsiElement label = this.getLabel();
        return label.getText();
    }

    @Override
    public PsiElement getNameIdentifierGroovy() {
        return this.getLabel();
    }

    public PsiElement getNameIdentifier() {
        return this.getNameIdentifierGroovy();
    }

    public void deleteChildInternal(ASTNode child) {
        GrStatement statement = this.getStatement();
        if (statement != null && child == statement.getNode()) {
            this.delete();
        } else {
            super.deleteChildInternal(child);
        }
    }
}

