/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrClassInitializerImpl
extends GroovyPsiElementImpl
implements GrClassInitializer {
    public GrClassInitializerImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitClassInitializer(this);
    }

    public String toString() {
        return "Class initializer";
    }

    @Override
    public GrOpenBlock getBlock() {
        return (GrOpenBlock)this.findNotNullChildByClass(GrOpenBlock.class);
    }

    @Override
    public boolean isStatic() {
        return this.getModifierList().hasExplicitModifier("static");
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent = this.getParent();
        if (parent instanceof GrTypeDefinitionBody && (pparent = parent.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        return null;
    }

    @Override
    public GrMember[] getMembers() {
        return new GrMember[]{this};
    }

    @Override
    public GrModifierList getModifierList() {
        return (GrModifierList)this.findNotNullChildByClass(GrModifierList.class);
    }

    public boolean hasModifierProperty(@GrModifier.GrModifierConstant String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    public PsiCodeBlock getBody() {
        return PsiImplUtil.getOrCreatePsiCodeBlock(this.getBlock());
    }
}

