/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignatureVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GrMethodSignatureImpl
implements GrClosureSignature {
    private final PsiMethod myMethod;
    private final PsiSubstitutor mySubstitutor;

    public GrMethodSignatureImpl(PsiMethod method, PsiSubstitutor substitutor) {
        this.myMethod = method;
        this.mySubstitutor = substitutor;
    }

    @Override
    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Override
    public GrClosureParameter[] getParameters() {
        Object[] parameters = this.myMethod.getParameterList().getParameters();
        return (GrClosureParameter[])ContainerUtil.map((Object[])parameters, (Function)new Function<PsiParameter, GrClosureParameter>(){

            public GrClosureParameter fun(PsiParameter parameter) {
                return GrMethodSignatureImpl.this.createClosureParameter(parameter);
            }
        }, (Object[])new GrClosureParameter[parameters.length]);
    }

    protected GrClosureParameter createClosureParameter(PsiParameter parameter) {
        return new GrClosureParameterImpl(parameter, this.getSubstitutor());
    }

    @Override
    public int getParameterCount() {
        return this.myMethod.getParameterList().getParametersCount();
    }

    @Override
    public boolean isVarargs() {
        return GrClosureSignatureUtil.isVarArgsImpl(this.getParameters());
    }

    @Override
    public PsiType getReturnType() {
        return this.getSubstitutor().substitute(PsiUtil.getSmartReturnType(this.myMethod));
    }

    @Override
    public boolean isCurried() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myMethod.isValid() && this.getSubstitutor().isValid();
    }

    @Override
    public GrSignature curry(PsiType[] args, int position, PsiElement context) {
        return GrClosureSignatureUtil.curryImpl(this, args, position, context);
    }

    @Override
    public void accept(GrSignatureVisitor visitor) {
        visitor.visitClosureSignature(this);
    }
}

