/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class ArgumentInstruction
extends InstructionImpl
implements MixinTypeInstruction {
    private static final Logger LOG = Logger.getInstance(ArgumentInstruction.class);

    public ArgumentInstruction(GrReferenceExpression ref) {
        super(ref);
    }

    @Override
    public PsiType inferMixinType() {
        PsiElement element = this.getElement();
        assert (element != null);
        GrCall call = ArgumentInstruction.findCall(element);
        Object[] arguments = call.getExpressionArguments();
        boolean hasNamed = PsiImplUtil.hasNamedArguments(call.getArgumentList());
        int index = ArrayUtil.indexOf((Object[])arguments, (Object)element) + (hasNamed ? 1 : 0);
        GroovyResolveResult[] variants = call.getCallVariants((GrReferenceExpression)element);
        PsiType result = null;
        for (GroovyResolveResult variant : variants) {
            GrClosureSignature signature = GrClosureSignatureUtil.createSignature(variant);
            if (signature == null) continue;
            if (GrClosureSignatureUtil.mapParametersToArguments(signature, call) != null && !ArgumentInstruction.haveNullParameters(call)) {
                return null;
            }
            GrClosureParameter[] parameters = signature.getParameters();
            if (index >= parameters.length) continue;
            result = TypesUtil.getLeastUpperBoundNullable(result, parameters[index].getType(), element.getManager());
        }
        return result;
    }

    private static boolean haveNullParameters(GrCall call) {
        for (GrExpression argument : call.getExpressionArguments()) {
            if (argument.getType() != null) continue;
            return true;
        }
        return false;
    }

    private static GrCall findCall(PsiElement element) {
        PsiElement parent = element.getParent().getParent();
        if (!(parent instanceof GrCall)) {
            LOG.error("elemText: " + element.getText() + "\nisValid = " + element.isValid() + "\nParent = " + (element.getParent() == null ? "null" : element.getParent().getClass()) + "\nPParent = " + (parent == null ? "null" : parent.getClass()));
        }
        return (GrCall)parent;
    }

    @Override
    public ReadWriteVariableInstruction getInstructionToMixin(Instruction[] flow) {
        Instruction instruction = ControlFlowUtils.findInstruction(this.getElement(), flow);
        if (instruction instanceof ReadWriteVariableInstruction) {
            return (ReadWriteVariableInstruction)instruction;
        }
        return null;
    }

    @Override
    public String getVariableName() {
        return ((GrReferenceExpression)this.getElement()).getReferenceName();
    }

    @Override
    public ConditionInstruction getConditionInstruction() {
        return null;
    }

    @Override
    protected String getElementPresentation() {
        return "ARGUMENT " + super.getElementPresentation();
    }
}

