/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.api;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.CollectionUtil;

public final class SpreadState {
    public static final Key<SpreadState> SPREAD_STATE = Key.create((String)"Spread state");
    private final PsiType containerType;
    private final SpreadState innerState;

    public SpreadState(PsiType type, SpreadState state) {
        this.containerType = type;
        this.innerState = state;
    }

    public PsiType getContainerType() {
        return this.containerType;
    }

    public SpreadState getInnerState() {
        return this.innerState;
    }

    public static SpreadState create(PsiType type, SpreadState state) {
        return new SpreadState(type, state);
    }

    public static PsiType apply(PsiType item, SpreadState state, Project project) {
        if (state == null) {
            return item;
        }
        return SpreadState.apply((PsiType)CollectionUtil.createSimilarCollection(state.getContainerType(), project, item), state.getInnerState(), project);
    }
}

