/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.parser.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class GroovyDocParsing {
    private static final String SEE_TAG = "@see";
    private static final String LINK_TAG = "@link";
    private static final String LINKPLAIN_TAG = "@linkplain";
    private static final String THROWS_TAG = "@throws";
    private static final String EXCEPTION_TAG = "@exception";
    private static final String PARAM_TAG = "@param";
    private static final String VALUE_TAG = "@value";
    private static final TokenSet REFERENCE_BEGIN = TokenSet.create((IElementType[])new IElementType[]{GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN, GroovyDocTokenTypes.mGDOC_TAG_VALUE_SHARP_TOKEN});
    private boolean isInInlinedTag = false;
    private int myBraceCounter = 0;

    public boolean parse(PsiBuilder builder) {
        while (this.parseDataItem(builder)) {
        }
        if (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_COMMENT_END) {
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        return true;
    }

    private boolean parseDataItem(PsiBuilder builder) {
        if (GroovyDocParsing.timeToEnd(builder)) {
            return false;
        }
        if (ParserUtils.lookAhead(builder, GroovyDocTokenTypes.mGDOC_INLINE_TAG_START, GroovyDocTokenTypes.mGDOC_TAG_NAME) && !this.isInInlinedTag) {
            this.isInInlinedTag = true;
            this.parseTag(builder);
        } else if (GroovyDocTokenTypes.mGDOC_TAG_NAME == builder.getTokenType() && !this.isInInlinedTag) {
            this.parseTag(builder);
        } else {
            builder.advanceLexer();
        }
        return true;
    }

    private static boolean timeToEnd(PsiBuilder builder) {
        return builder.eof() || builder.getTokenType() == GroovyDocTokenTypes.mGDOC_COMMENT_END;
    }

    private boolean parseTag(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (this.isInInlinedTag) {
            ParserUtils.getToken(builder, GroovyDocTokenTypes.mGDOC_INLINE_TAG_START);
        }
        assert (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_TAG_NAME);
        String tagName = builder.getTokenText();
        builder.advanceLexer();
        if (this.isInInlinedTag) {
            if (LINK_TAG.equals(tagName) || LINKPLAIN_TAG.equals(tagName) || VALUE_TAG.equals(tagName)) {
                this.parseSeeOrLinkTagReference(builder);
            }
        } else if (THROWS_TAG.equals(tagName) || EXCEPTION_TAG.equals(tagName)) {
            this.parseReferenceOrType(builder);
        } else if (SEE_TAG.equals(tagName)) {
            this.parseSeeOrLinkTagReference(builder);
        } else if (PARAM_TAG.equals(tagName)) {
            this.parseParamTagReference(builder);
        }
        while (!GroovyDocParsing.timeToEnd(builder)) {
            if (this.isInInlinedTag) {
                if (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_INLINE_TAG_START) {
                    ++this.myBraceCounter;
                    builder.advanceLexer();
                    continue;
                }
                if (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_INLINE_TAG_END) {
                    if (this.myBraceCounter > 0) {
                        --this.myBraceCounter;
                        builder.advanceLexer();
                        continue;
                    }
                    builder.advanceLexer();
                    this.isInInlinedTag = false;
                    marker.done((IElementType)GroovyDocElementTypes.GDOC_INLINED_TAG);
                    return true;
                }
                builder.advanceLexer();
                continue;
            }
            if (ParserUtils.lookAhead(builder, GroovyDocTokenTypes.mGDOC_INLINE_TAG_START, GroovyDocTokenTypes.mGDOC_TAG_NAME)) {
                this.isInInlinedTag = true;
                this.parseTag(builder);
                continue;
            }
            if (GroovyDocTokenTypes.mGDOC_TAG_NAME == builder.getTokenType()) {
                marker.done((IElementType)GroovyDocElementTypes.GDOC_TAG);
                return true;
            }
            builder.advanceLexer();
        }
        marker.done((IElementType)(this.isInInlinedTag ? GroovyDocElementTypes.GDOC_INLINED_TAG : GroovyDocElementTypes.GDOC_TAG));
        this.isInInlinedTag = false;
        return true;
    }

    private boolean parseParamTagReference(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN == builder.getTokenType()) {
            builder.advanceLexer();
            marker.done((IElementType)GroovyDocElementTypes.GDOC_PARAM_REF);
            return true;
        }
        if (ParserUtils.lookAhead(builder, GroovyDocTokenTypes.mGDOC_TAG_VALUE_LT, GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN)) {
            builder.advanceLexer();
            builder.getTokenText();
            builder.advanceLexer();
            if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_GT == builder.getTokenType()) {
                builder.advanceLexer();
            }
            marker.done((IElementType)GroovyDocElementTypes.GDOC_PARAM_REF);
            return true;
        }
        marker.drop();
        return false;
    }

    private boolean parseSeeOrLinkTagReference(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        if (!REFERENCE_BEGIN.contains(type)) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN == type) {
            builder.advanceLexer();
        }
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_SHARP_TOKEN == builder.getTokenType()) {
            builder.advanceLexer();
            RESULT result = this.parseFieldOrMethod(builder);
            if (result == RESULT.ERROR) {
                marker.drop();
            } else if (result == RESULT.METHOD) {
                marker.done((IElementType)GroovyDocElementTypes.GDOC_METHOD_REF);
            } else {
                marker.done((IElementType)GroovyDocElementTypes.GDOC_FIELD_REF);
            }
            return true;
        }
        marker.drop();
        return true;
    }

    private RESULT parseFieldOrMethod(PsiBuilder builder) {
        if (builder.getTokenType() != GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN) {
            return RESULT.ERROR;
        }
        builder.advanceLexer();
        PsiBuilder.Marker params = builder.mark();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN != builder.getTokenType()) {
            params.drop();
            return RESULT.FIELD;
        }
        builder.advanceLexer();
        while (this.parseMethodParameter(builder) && !GroovyDocParsing.timeToEnd(builder)) {
            while (GroovyDocTokenTypes.mGDOC_TAG_VALUE_COMMA != builder.getTokenType() && GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN != builder.getTokenType() && !GroovyDocParsing.timeToEnd(builder)) {
                builder.advanceLexer();
            }
            while (GroovyDocTokenTypes.mGDOC_TAG_VALUE_COMMA == builder.getTokenType()) {
                builder.advanceLexer();
            }
        }
        if (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN) {
            builder.advanceLexer();
        }
        params.done((IElementType)GroovyDocElementTypes.GDOC_METHOD_PARAMS);
        return RESULT.METHOD;
    }

    private boolean parseMethodParameter(PsiBuilder builder) {
        PsiBuilder.Marker param = builder.mark();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN != builder.getTokenType()) {
            param.drop();
            return false;
        }
        builder.advanceLexer();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN == builder.getTokenType()) {
            builder.advanceLexer();
        }
        param.done((IElementType)GroovyDocElementTypes.GDOC_METHOD_PARAMETER);
        return true;
    }

    private boolean parseReferenceOrType(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        return GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN == type;
    }

    static enum RESULT {
        ERROR,
        METHOD,
        FIELD;

    }
}

