/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.other;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GrAliasImportIntention
extends Intention {
    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        PsiMember resolved;
        GrImportStatement context;
        if (element instanceof GrReferenceExpression) {
            GrReferenceExpression ref = (GrReferenceExpression)element;
            GroovyResolveResult result = ref.advancedResolve();
            context = (GrImportStatement)result.getCurrentFileResolveContext();
            assert (context != null);
            resolved = (PsiMember)result.getElement();
        } else if (element instanceof GrImportStatement) {
            context = (GrImportStatement)element;
            resolved = (PsiMember)context.getImportReference().resolve();
        } else {
            return;
        }
        assert (resolved != null);
        GrAliasImportIntention.doRefactoring(project, context, resolved);
    }

    private static void doRefactoring(Project project, GrImportStatement importStatement, PsiMember member) {
        if (member instanceof GrAccessorMethod && !importStatement.isOnDemand() && !importStatement.getImportedName().equals(member.getName())) {
            member = ((GrAccessorMethod)member).getProperty();
        }
        GroovyFileBase file = (GroovyFileBase)importStatement.getContainingFile();
        List<UsageInfo> usages = GrAliasImportIntention.findUsages(member, file);
        GrImportStatement templateImport = GrAliasImportIntention.createTemplateImport(project, importStatement, member, file);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!importStatement.isOnDemand()) {
                importStatement.delete();
            }
            GrAliasImportIntention.updateRefs(usages, member.getName(), templateImport);
        } else {
            GrAliasImportIntention.runTemplate(project, importStatement, member, file, usages, templateImport);
        }
    }

    private static GrImportStatement createTemplateImport(Project project, GrImportStatement context, PsiMember resolved, GroovyFileBase file) {
        PsiClass aClass = resolved.getContainingClass();
        assert (aClass != null);
        String qname = aClass.getQualifiedName();
        String name = resolved.getName();
        GrImportStatement template = GroovyPsiElementFactory.getInstance(project).createImportStatementFromText("import static " + qname + "." + name + " as aliased");
        return file.addImport(template);
    }

    private static void runTemplate(Project project, GrImportStatement context, PsiMember resolved, final GroovyFileBase file, final List<UsageInfo> usages, GrImportStatement templateImport) {
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting();
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)templateImport);
        LinkedHashSet<String> names = GrAliasImportIntention.getSuggestedNames((PsiElement)resolved, context);
        PsiElement aliasNameElement = templateImport.getAliasNameElement();
        assert (aliasNameElement != null);
        templateBuilder.replaceElement(aliasNameElement, (Expression)new MyLookupExpression(resolved.getName(), names, (PsiNamedElement)resolved, (PsiElement)resolved, true, null));
        Template built = templateBuilder.buildTemplate();
        Editor newEditor = IntentionUtils.positionCursor(project, file, templateImport);
        Document document = newEditor.getDocument();
        final RangeMarker contextImportPointer = document.createRangeMarker(context.getTextRange());
        final TextRange range = templateImport.getTextRange();
        document.deleteString(range.getStartOffset(), range.getEndOffset());
        final String name = resolved.getName();
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, built, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                final GrImportStatement importStatement = (GrImportStatement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GrImportStatement>(){

                    public GrImportStatement compute() {
                        return (GrImportStatement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)range.getStartOffset(), GrImportStatement.class, (boolean)true);
                    }
                });
                if (brokenOff) {
                    if (importStatement != null) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                importStatement.delete();
                            }
                        });
                    }
                    return;
                }
                GrAliasImportIntention.updateRefs(usages, name, importStatement);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        GrImportStatement context = (GrImportStatement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)contextImportPointer.getStartOffset(), (int)contextImportPointer.getEndOffset(), GrImportStatement.class);
                        if (context != null) {
                            context.delete();
                        }
                    }
                });
            }
        });
    }

    private static void updateRefs(List<UsageInfo> usages, final String memberName, final GrImportStatement updatedImport) {
        if (updatedImport == null) {
            return;
        }
        final String name = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return updatedImport.getImportedName();
            }
        });
        for (final UsageInfo usage : usages) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    GrReferenceElement ref;
                    PsiElement qualifier;
                    PsiElement usageElement = usage.getElement();
                    if (usageElement == null) {
                        return;
                    }
                    if (usageElement.getParent() instanceof GrImportStatement) {
                        return;
                    }
                    if (usageElement instanceof GrReferenceElement && (qualifier = (ref = (GrReferenceElement)usageElement).getQualifier()) == null) {
                        String refName = ref.getReferenceName();
                        if (refName == null) {
                            return;
                        }
                        if (memberName.equals(refName)) {
                            ref.handleElementRenameSimple(name);
                        } else if (refName.equals(GroovyPropertyUtils.getPropertyNameByAccessorName(memberName))) {
                            String newPropName = GroovyPropertyUtils.getPropertyNameByAccessorName(name);
                            if (newPropName != null) {
                                ref.handleElementRenameSimple(newPropName);
                            } else {
                                ref.handleElementRenameSimple(name);
                            }
                        } else if (refName.equals(GroovyPropertyUtils.getGetterNameBoolean(memberName))) {
                            String getterName = GroovyPropertyUtils.getGetterNameBoolean(name);
                            ref.handleElementRenameSimple(getterName);
                        } else if (refName.equals(GroovyPropertyUtils.getGetterNameNonBoolean(memberName))) {
                            String getterName = GroovyPropertyUtils.getGetterNameNonBoolean(name);
                            ref.handleElementRenameSimple(getterName);
                        } else if (refName.equals(GroovyPropertyUtils.getSetterName(memberName))) {
                            String getterName = GroovyPropertyUtils.getSetterName(name);
                            ref.handleElementRenameSimple(getterName);
                        }
                    }
                }
            });
        }
    }

    private static List<UsageInfo> findUsages(PsiMember member, GroovyFileBase file) {
        LocalSearchScope scope = new LocalSearchScope((PsiElement)file);
        final ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>();
        final HashSet usedRefs = ContainerUtil.newHashSet();
        Processor<PsiReference> consumer = new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                if (usedRefs.add(reference)) {
                    infos.add(new UsageInfo(reference));
                }
                return true;
            }
        };
        if (member instanceof PsiMethod) {
            MethodReferencesSearch.search((PsiMethod)((PsiMethod)member), (SearchScope)scope, (boolean)false).forEach((Processor)consumer);
        } else {
            ReferencesSearch.search((PsiElement)member, (SearchScope)scope).forEach((Processor)consumer);
            if (member instanceof PsiField) {
                PsiMethod setter;
                PsiMethod getter = GroovyPropertyUtils.findGetterForField((PsiField)member);
                if (getter != null) {
                    MethodReferencesSearch.search((PsiMethod)getter, (SearchScope)scope, (boolean)false).forEach((Processor)consumer);
                }
                if ((setter = GroovyPropertyUtils.findSetterForField((PsiField)member)) != null) {
                    MethodReferencesSearch.search((PsiMethod)setter, (SearchScope)scope, (boolean)false).forEach((Processor)consumer);
                }
            }
        }
        return infos;
    }

    public static LinkedHashSet<String> getSuggestedNames(PsiElement psiElement, PsiElement nameSuggestionContext) {
        NameSuggestionProvider provider;
        SuggestedNameInfo info;
        NameSuggestionProvider[] providers;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(UsageViewUtil.getShortName((PsiElement)psiElement));
        NameSuggestionProvider[] arr$ = providers = (NameSuggestionProvider[])Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((info = (provider = arr$[i$]).getSuggestedNames(psiElement, nameSuggestionContext, result)) == null || !(provider instanceof PreferrableNameSuggestionProvider) || ((PreferrableNameSuggestionProvider)provider).shouldCheckOthers()); ++i$) {
        }
        return result;
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (element instanceof GrReferenceExpression) {
                    GroovyResolveResult result = ((GrReferenceExpression)element).advancedResolve();
                    PsiElement context = result.getCurrentFileResolveContext();
                    if (!(context instanceof GrImportStatement)) {
                        return false;
                    }
                    GrImportStatement importStatement = (GrImportStatement)context;
                    return importStatement.isStatic() && !importStatement.isAliasedImport();
                }
                if (element instanceof GrImportStatement) {
                    GrImportStatement importStatement = (GrImportStatement)element;
                    if (!importStatement.isStatic()) {
                        return false;
                    }
                    if (importStatement.isOnDemand()) {
                        return false;
                    }
                    return !importStatement.isAliasedImport();
                }
                return false;
            }
        };
    }
}

