/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceVariableHandler;

public class GrIntroduceLocalVariableIntention
extends Intention {
    protected PsiElement getTargetExpression(PsiElement element) {
        if (GrIntroduceLocalVariableIntention.isTargetVisible(element)) {
            return element;
        }
        PsiElement expression = PsiTreeUtil.getParentOfType((PsiElement)element, GrExpression.class);
        return expression == null ? null : this.getTargetExpression(expression);
    }

    private static boolean isTargetVisible(PsiElement element) {
        return PsiUtil.isExpressionStatement(element) && element instanceof GrExpression && ((GrExpression)element).getType() != PsiType.VOID && PsiTreeUtil.getParentOfType((PsiElement)element, GrAssignmentExpression.class) == null;
    }

    protected void setSelection(Editor editor, PsiElement element) {
        int offset = element.getTextOffset();
        int length = element.getTextLength();
        editor.getSelectionModel().setSelection(offset, offset + length);
    }

    @Override
    protected void processIntention(PsiElement element, final Project project, final Editor editor) throws IncorrectOperationException {
        this.setSelection(editor, this.getTargetExpression(element));
        final PsiFile file = element.getContainingFile();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                new GrIntroduceVariableHandler().invoke(project, editor, file, null);
            }
        });
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (element == null) {
                    return false;
                }
                return GrIntroduceLocalVariableIntention.this.getTargetExpression(element) != null;
            }
        };
    }
}

