/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GrConvertStringToCharIntention
extends Intention {
    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrExpression cast = GroovyPsiElementFactory.getInstance(project).createExpressionFromText("a as char");
        ((GrSafeCastExpression)cast).getOperand().replaceWithExpression((GrExpression)element, true);
        ((GrExpression)element).replaceWithExpression(cast, true);
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof GrLiteral)) {
                    return false;
                }
                Object value = ((GrLiteral)element).getValue();
                return value instanceof String && ((String)value).length() == 1;
            }
        };
    }
}

