/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.RemoveParenthesesFromMethodPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class RemoveParenthesesFromMethodCallIntention
extends Intention {
    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new RemoveParenthesesFromMethodPredicate();
    }

    @Override
    protected boolean isStopElement(PsiElement element) {
        return super.isStopElement(element) || element instanceof GrStatementOwner;
    }

    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrMethodCallExpression expression = (GrMethodCallExpression)element;
        StringBuilder newStatementText = new StringBuilder();
        newStatementText.append(expression.getInvokedExpression().getText()).append(' ');
        GrArgumentList argumentList = expression.getArgumentList();
        if (argumentList != null) {
            PsiElement leftParen = argumentList.getLeftParen();
            PsiElement rightParen = argumentList.getRightParen();
            if (leftParen != null) {
                leftParen.delete();
            }
            if (rightParen != null) {
                rightParen.delete();
            }
            newStatementText.append(argumentList.getText());
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrStatement newStatement = factory.createStatementFromText(newStatementText.toString());
        expression.replaceWithStatement(newStatement);
    }
}

