/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

class ClassNameDiffersFromFileNamePredicate
implements PsiElementPredicate {
    private final Consumer<GrTypeDefinition> myClassConsumer;
    private final boolean mySearchForClassInMultiClassFile;

    ClassNameDiffersFromFileNamePredicate(Consumer<GrTypeDefinition> classConsumer, boolean searchForClassInMultiClassFile) {
        this.myClassConsumer = classConsumer;
        this.mySearchForClassInMultiClassFile = searchForClassInMultiClassFile;
    }

    ClassNameDiffersFromFileNamePredicate(Consumer<GrTypeDefinition> classConsumer) {
        this(classConsumer, false);
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiFile file;
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrTypeDefinition)) {
            return false;
        }
        if (((GrTypeDefinition)parent).getNameIdentifierGroovy() != element) {
            return false;
        }
        String name = ((GrTypeDefinition)parent).getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (this.myClassConsumer != null) {
            this.myClassConsumer.consume((Object)((GrTypeDefinition)parent));
        }
        if (!((file = element.getContainingFile()) instanceof GroovyFile)) {
            return false;
        }
        if (!file.isPhysical()) {
            return false;
        }
        if (name.equals(FileUtil.getNameWithoutExtension((String)file.getName()))) {
            return false;
        }
        if (this.mySearchForClassInMultiClassFile) {
            return ((GroovyFile)file).getClasses().length > 1;
        }
        return !((GroovyFile)file).isScript();
    }
}

