/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.griffon.GriffonFramework;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.resolve.DefaultImportContributor;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class GriffonDefaultImportContributor
extends DefaultImportContributor {
    private static Couple<List<String>> getDefaultImports(final Module module) {
        return (Couple)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Couple<List<String>>>(){

            public CachedValueProvider.Result<Couple<List<String>>> compute() {
                PsiPackage aPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("META-INF");
                if (aPackage != null) {
                    for (PsiDirectory directory : aPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) {
                        PsiFile file = directory.findFile("griffon-default-imports.properties");
                        if (!(file instanceof PropertiesFile)) continue;
                        List<String> modelImports = this.tokenize(((PropertiesFile)file).findPropertyByKey("models"));
                        List<String> viewImports = this.tokenize(((PropertiesFile)file).findPropertyByKey("views"));
                        return CachedValueProvider.Result.create((Object)Couple.of(modelImports, viewImports), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                }
                return CachedValueProvider.Result.create((Object)Couple.of(new ArrayList(), new ArrayList()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }

            private List<String> tokenize(IProperty models) {
                String value;
                ArrayList<String> modelImports = new ArrayList<String>();
                if (models != null && (value = models.getValue()) != null) {
                    String[] split;
                    for (String s : split = value.split(", ")) {
                        modelImports.add(StringUtil.trimEnd((String)s, (String)"."));
                    }
                }
                return modelImports;
            }
        });
    }

    @Override
    public List<String> appendImplicitlyImportedPackages(GroovyFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        MvcFramework framework = MvcFramework.getInstance(module);
        if (framework instanceof GriffonFramework) {
            ArrayList<String> result = new ArrayList<String>();
            result.add("griffon.core");
            result.add("griffon.util");
            VirtualFile griffonApp = framework.findAppDirectory(file);
            if (griffonApp != null) {
                VirtualFile models = griffonApp.findChild("models");
                VirtualFile views = griffonApp.findChild("views");
                VirtualFile vFile = file.getOriginalFile().getVirtualFile();
                assert (vFile != null);
                assert (module != null);
                if (models != null && VfsUtilCore.isAncestor((VirtualFile)models, (VirtualFile)vFile, (boolean)true)) {
                    result.addAll((Collection)GriffonDefaultImportContributor.getDefaultImports((Module)module).first);
                } else if (views != null && VfsUtilCore.isAncestor((VirtualFile)views, (VirtualFile)vFile, (boolean)true)) {
                    result.addAll((Collection)GriffonDefaultImportContributor.getDefaultImports((Module)module).second);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }
}

