/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import org.jetbrains.plugins.groovy.griffon.GriffonRunConfiguration;

public class GriffonDebuggerRunner
extends GenericDebuggerRunner {
    public boolean canRun(String executorId, RunProfile profile) {
        return executorId.equals(DefaultDebugExecutor.EXECUTOR_ID) && profile instanceof GriffonRunConfiguration;
    }

    public String getRunnerId() {
        return "GriffonDebugger";
    }

    protected RunContentDescriptor createContentDescriptor(RunProfileState state, ExecutionEnvironment environment) throws ExecutionException {
        JavaCommandLine javaCommandLine = (JavaCommandLine)state;
        JavaParameters params = javaCommandLine.getJavaParameters();
        if (!params.getVMParametersList().hasProperty("griffon.full.stacktrace")) {
            params.getVMParametersList().add("-Dgriffon.full.stacktrace=true");
        }
        String address = null;
        try {
            for (String s : params.getProgramParametersList().getList()) {
                if (!s.startsWith("run-")) continue;
                address = DebuggerUtils.getInstance().findAvailableDebugAddress(true);
                params.getProgramParametersList().replaceOrAppend(s, s + " --debug --debugPort=" + address);
                break;
            }
        }
        catch (ExecutionException ignored) {
            // empty catch block
        }
        if (address == null) {
            return super.createContentDescriptor(state, environment);
        }
        return this.attachVirtualMachine(state, environment, new RemoteConnection(true, "127.0.0.1", address, false), true);
    }
}

