/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GppLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    private static final LibraryKind GPP_KIND = LibraryKind.create((String)"gpp");
    private static final Pattern GROOVYPP_JAR = Pattern.compile("groovypp-([\\d\\.]+)\\.jar");
    private static final Pattern GROOVYPP_ALL_JAR = Pattern.compile("groovypp-all-([\\d\\.]+)\\.jar");

    public GppLibraryPresentationProvider() {
        super(GPP_KIND);
    }

    @Override
    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File srcRoot;
        File lib = new File(path + "/lib");
        if (lib.exists()) {
            libraryEditor.addJarDirectory(VfsUtil.getUrlForLibraryRoot((File)lib), false, OrderRootType.CLASSES);
        }
        GppLibraryPresentationProvider.addSources(libraryEditor, (srcRoot = new File(path + "/src")).exists() ? srcRoot : new File(path));
    }

    private static void addSources(LibraryEditor libraryEditor, File srcRoot) {
        File mainSrc;
        File stdLibSrc;
        File compilerSrc = new File(srcRoot, "Compiler/src");
        if (compilerSrc.exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)compilerSrc), OrderRootType.SOURCES);
        }
        if ((stdLibSrc = new File(srcRoot, "StdLib/src")).exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)stdLibSrc), OrderRootType.SOURCES);
        }
        if ((mainSrc = new File(srcRoot, "main")).exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)mainSrc), OrderRootType.SOURCES);
        }
    }

    @Override
    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return GppLibraryPresentationProvider.getGppVersion(libraryFiles) != null;
    }

    @Override
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        return GppLibraryPresentationProvider.getGppVersion(libraryFiles);
    }

    private static String getGppVersion(VirtualFile[] files) {
        for (VirtualFile file : files) {
            Matcher matcher = GROOVYPP_JAR.matcher(file.getName());
            if (matcher.matches()) {
                return matcher.group(1);
            }
            matcher = GROOVYPP_ALL_JAR.matcher(file.getName());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    @Override
    public String getSDKVersion(String path) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        assert (file != null);
        VirtualFile libDir = file.findChild("lib");
        assert (libDir != null);
        String version = GppLibraryPresentationProvider.getGppVersion(libDir.getChildren());
        if (version != null) {
            return version;
        }
        throw new AssertionError((Object)path);
    }

    @Override
    public String getLibraryCategoryName() {
        return "Groovy++";
    }

    @Override
    public boolean managesName(String name) {
        return super.managesName(name) || StringUtil.startsWithIgnoreCase((String)name, (String)"groovypp");
    }

    @Override
    public boolean isSDKHome(VirtualFile file) {
        VirtualFile libDir = file.findChild("lib");
        return libDir != null && GppLibraryPresentationProvider.getGppVersion(libDir.getChildren()) != null;
    }
}

