/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.lang.Language;
import com.intellij.lang.ant.AntIntrospector;
import com.intellij.lang.ant.dom.AntDomExtender;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JetgroovyIcons;
import java.util.Collections;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrBuilderMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

class AntBuilderMethod
extends LightMethodBuilder
implements GrBuilderMethod {
    private final PsiFile myPlace;
    private final Class myAntClass;

    public AntBuilderMethod(PsiFile place, String name, PsiType closureType, Class antClass, PsiType stringType) {
        super(place.getManager(), (Language)GroovyLanguage.INSTANCE, name);
        this.myPlace = place;
        this.myAntClass = antClass;
        this.setModifiers(new String[]{"public"});
        this.addParameter("args", (PsiType)GrMapType.create(place.getResolveScope()));
        this.setBaseIcon(JetgroovyIcons.Groovy.Ant_task);
        this.addParameter(new GrLightParameter("singleArg", stringType, (PsiElement)this).setOptional(true));
        this.addParameter(new GrLightParameter("body", closureType, (PsiElement)this).setOptional(true));
        this.setMethodReturnType((Computable)new Computable<PsiType>(){

            public PsiType compute() {
                return PsiType.getJavaLangObject((PsiManager)AntBuilderMethod.this.getManager(), (GlobalSearchScope)AntBuilderMethod.this.getResolveScope());
            }
        });
    }

    public PsiElement getNavigationElement() {
        PsiClass psiClass;
        if (this.myAntClass != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myAntClass.getName(), this.myPlace.getResolveScope())) != null) {
            return psiClass;
        }
        return this;
    }

    public boolean processNestedElements(PsiScopeProcessor processor) {
        AntIntrospector introspector = AntDomExtender.getIntrospector((Class)this.myAntClass);
        if (introspector != null) {
            String expectedName = ResolveUtil.getNameHint(processor);
            PsiType stringType = this.getParameterList().getParameters()[1].getType();
            PsiType closureType = this.getParameterList().getParameters()[2].getType();
            for (String name : Collections.list(introspector.getNestedElements())) {
                AntBuilderMethod method;
                if (expectedName != null && !expectedName.equals(name) || processor.execute((PsiElement)(method = new AntBuilderMethod(this.myPlace, name, closureType, introspector.getElementType(name), stringType)), ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasObligatoryNamedArguments() {
        return false;
    }
}

