/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.ILazyParseableElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyIndentProcessor;
import org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessor;
import org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessorBasic;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

public class GroovyBlock
implements Block,
ASTBlock {
    private static final Logger LOG = Logger.getInstance(GroovyBlock.class);
    protected final ASTNode myNode;
    protected Alignment myAlignment = null;
    protected final Indent myIndent;
    protected final Wrap myWrap;
    protected final FormattingContext myContext;
    protected List<Block> mySubBlocks = null;

    public GroovyBlock(ASTNode node, Indent indent, Wrap wrap, FormattingContext context) {
        this.myNode = node;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.myContext = context;
    }

    public ASTNode getNode() {
        return this.myNode;
    }

    public TextRange getTextRange() {
        return this.myNode.getTextRange();
    }

    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            try {
                this.mySubBlocks = new GroovyBlockGenerator(this).generateSubBlocks();
            }
            catch (AssertionError e) {
                PsiFile file = this.myNode.getPsi().getContainingFile();
                LogMessageEx.error((Logger)LOG, (String)("Formatting failed for file " + file.getName()), (Throwable)((Object)e), (String[])new String[]{file.getText(), this.myNode.getText()});
                this.mySubBlocks = new ArrayList<Block>();
            }
            catch (RuntimeException e) {
                PsiFile file = this.myNode.getPsi().getContainingFile();
                LogMessageEx.error((Logger)LOG, (String)("Formatting failed for file " + file.getName()), (Throwable)e, (String[])new String[]{file.getText(), this.myNode.getText()});
                this.mySubBlocks = new ArrayList<Block>();
            }
        }
        return this.mySubBlocks;
    }

    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Alignment getAlignment() {
        if (this.myAlignment == null) {
            this.myAlignment = this.myContext.getAlignmentProvider().getAlignment(this.myNode.getPsi());
        }
        return this.myAlignment;
    }

    public Spacing getSpacing(Block child1, Block child2) {
        if (child1 instanceof GroovyBlock && child2 instanceof GroovyBlock) {
            if (((GroovyBlock)child1).getNode() == ((GroovyBlock)child2).getNode()) {
                return Spacing.getReadOnlySpacing();
            }
            Spacing spacing = new GroovySpacingProcessor((GroovyBlock)child1, (GroovyBlock)child2, this.myContext).getSpacing();
            if (spacing != null) {
                return spacing;
            }
            return GroovySpacingProcessorBasic.getSpacing((GroovyBlock)child1, (GroovyBlock)child2, this.myContext);
        }
        return null;
    }

    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTNode astNode = this.getNode();
        PsiElement psiParent = astNode.getPsi();
        if (psiParent instanceof GroovyFileBase) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (psiParent instanceof GrSwitchStatement) {
            PsiElement anchorPsi;
            Block block;
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex > 0 && (block = subBlocks.get(newChildIndex - 1)) instanceof GroovyBlock && (anchorPsi = ((GroovyBlock)block).getNode().getPsi()) instanceof GrCaseSection) {
                for (GrStatement statement : ((GrCaseSection)anchorPsi).getStatements()) {
                    if (!(statement instanceof GrBreakStatement) && !(statement instanceof GrContinueStatement) && !(statement instanceof GrReturnStatement) && !(statement instanceof GrThrowStatement)) continue;
                    Indent indent = GroovyIndentProcessor.getSwitchCaseIndent(this.myContext.getSettings());
                    return new ChildAttributes(indent, null);
                }
                int indentSize = this.myContext.getSettings().getIndentOptions().INDENT_SIZE;
                int spaces = this.myContext.getSettings().INDENT_CASE_FROM_SWITCH ? 2 * indentSize : indentSize;
                return new ChildAttributes(Indent.getSpaceIndent((int)spaces), null);
            }
        }
        if (psiParent instanceof GrCaseLabel) {
            return new ChildAttributes(GroovyIndentProcessor.getSwitchCaseIndent(this.getContext().getSettings()), null);
        }
        if (psiParent instanceof GrCaseSection) {
            return this.getSwitchIndent((GrCaseSection)psiParent, newChildIndex);
        }
        if (TokenSets.BLOCK_SET.contains(astNode.getElementType()) || ((Object)((Object)GroovyElementTypes.SWITCH_STATEMENT)).equals(astNode.getElementType())) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (((Object)((Object)GroovyElementTypes.CASE_SECTION)).equals(astNode.getElementType())) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (psiParent instanceof GrBinaryExpression || psiParent instanceof GrConditionalExpression || psiParent instanceof GrCommandArgumentList || psiParent instanceof GrArgumentList || psiParent instanceof GrParameterList || psiParent instanceof GrListOrMap || psiParent instanceof GrAnnotationArgumentList || psiParent instanceof GrVariable || psiParent instanceof GrAssignmentExpression) {
            return new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
        }
        if (psiParent instanceof GrDocComment || psiParent instanceof GrDocTag) {
            return new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        }
        if (psiParent instanceof GrIfStatement || psiParent instanceof GrLoopStatement) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (psiParent instanceof GrLabeledStatement && newChildIndex == 2) {
            Indent indent = this.getContext().getGroovySettings().INDENT_LABEL_BLOCKS ? Indent.getLabelIndent() : Indent.getNoneIndent();
            return new ChildAttributes(indent, null);
        }
        return new ChildAttributes(Indent.getNoneIndent(), null);
    }

    private ChildAttributes getSwitchIndent(GrCaseSection psiParent, int newIndex) {
        GrStatement[] statements = psiParent.getStatements();
        --newIndex;
        for (int i = 0; i < statements.length && i < newIndex; ++i) {
            GrStatement statement = statements[i];
            if (!(statement instanceof GrBreakStatement) && !(statement instanceof GrContinueStatement) && !(statement instanceof GrReturnStatement) && !(statement instanceof GrThrowStatement)) continue;
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        Indent indent = GroovyIndentProcessor.getSwitchCaseIndent(this.getContext().getSettings());
        return new ChildAttributes(indent, null);
    }

    public boolean isIncomplete() {
        return GroovyBlock.isIncomplete(this.myNode);
    }

    public static boolean isIncomplete(ASTNode node) {
        ASTNode lastChild;
        if (node.getElementType() instanceof ILazyParseableElementType) {
            return false;
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && !(lastChild.getElementType() instanceof ILazyParseableElementType) && (lastChild.getPsi() instanceof PsiWhiteSpace || lastChild.getPsi() instanceof PsiComment); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild != null && (lastChild.getPsi() instanceof PsiErrorElement || GroovyBlock.isIncomplete(lastChild));
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    public String toString() {
        return this.getTextRange() + ": " + this.myNode;
    }

    public FormattingContext getContext() {
        return this.myContext;
    }
}

