/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class HandlerUtils {
    private HandlerUtils() {
    }

    public static boolean isEnabled(Editor editor, DataContext dataContext, EditorActionHandler originalHandler) {
        Language language;
        Project project = HandlerUtils.getProject(dataContext);
        if (project != null && (language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project)) == GroovyLanguage.INSTANCE) {
            return true;
        }
        return originalHandler == null || originalHandler.isEnabled(editor, dataContext);
    }

    public static boolean isReadOnly(Editor editor) {
        if (editor.isViewer()) {
            return true;
        }
        Document document = editor.getDocument();
        return !document.isWritable();
    }

    public static boolean canBeInvoked(Editor editor, Project project) {
        if (HandlerUtils.isReadOnly(editor)) {
            return false;
        }
        return HandlerUtils.getPsiFile(editor, project) != null;
    }

    public static PsiFile getPsiFile(Editor editor, DataContext dataContext) {
        return HandlerUtils.getPsiFile(editor, HandlerUtils.getProject(dataContext));
    }

    public static PsiFile getPsiFile(Editor editor, Project project) {
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
    }

    public static Language getLanguage(DataContext dataContext) {
        return (Language)DataKeys.LANGUAGE.getData(dataContext);
    }

    public static Project getProject(DataContext dataContext) {
        return (Project)DataKeys.PROJECT.getData(dataContext);
    }
}

