/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;

public class CompositeContextFilter
implements ContextFilter {
    private final List<ContextFilter> myFilters;
    private final boolean myAnd;

    private CompositeContextFilter(List<ContextFilter> filters, boolean and) {
        this.myFilters = filters;
        this.myAnd = and;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        for (ContextFilter filter : this.myFilters) {
            if (this.myAnd == filter.isApplicable(descriptor, ctx)) continue;
            return !this.myAnd;
        }
        return this.myAnd;
    }

    public static ContextFilter compose(List<ContextFilter> filters, boolean and) {
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new CompositeContextFilter(filters, and);
    }
}

