/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GroovyExtensionProvider {
    public static final String ORG_CODEHAUS_GROOVY_RUNTIME_EXTENSION_MODULE = "org.codehaus.groovy.runtime.ExtensionModule";
    private final Project myProject;

    public GroovyExtensionProvider(Project project) {
        this.myProject = project;
    }

    public static GroovyExtensionProvider getInstance(Project project) {
        return (GroovyExtensionProvider)ServiceManager.getService((Project)project, GroovyExtensionProvider.class);
    }

    public Couple<List<String>> collectExtensions(GlobalSearchScope resolveScope) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage("META-INF.services");
        if (aPackage == null) {
            return Couple.of(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<String> instanceClasses = new ArrayList<String>();
        ArrayList<String> staticClasses = new ArrayList<String>();
        for (PsiDirectory directory : aPackage.getDirectories(resolveScope)) {
            PsiFile file = directory.findFile(ORG_CODEHAUS_GROOVY_RUNTIME_EXTENSION_MODULE);
            if (!(file instanceof PropertiesFile)) continue;
            IProperty inst = ((PropertiesFile)file).findPropertyByKey("extensionClasses");
            IProperty stat = ((PropertiesFile)file).findPropertyByKey("staticExtensionClasses");
            if (inst != null) {
                GroovyExtensionProvider.collectClasses(inst, instanceClasses);
            }
            if (stat == null) continue;
            GroovyExtensionProvider.collectClasses(stat, staticClasses);
        }
        return Couple.of(instanceClasses, staticClasses);
    }

    private static void collectClasses(IProperty pr, List<String> classes) {
        String value = pr.getUnescapedValue();
        if (value == null) {
            return;
        }
        value = value.trim();
        Object[] qnames = value.split("\\s*,\\s*");
        ContainerUtil.addAll(classes, (Object[])qnames);
    }

    public static class GroovyExtensionVetoSPI
    implements Condition<String> {
        public boolean value(String s) {
            return GroovyExtensionProvider.ORG_CODEHAUS_GROOVY_RUNTIME_EXTENSION_MODULE.equals(s);
        }
    }
}

