/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import org.jetbrains.plugins.groovy.config.GroovyAwareModuleBuilder;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.config.GroovyFrameworkType;
import org.jetbrains.plugins.groovy.config.GroovySupportConfigurable;

public class GroovyFrameworkSupportProvider
extends FrameworkSupportInModuleProvider {
    public FrameworkTypeEx getFrameworkType() {
        return (FrameworkTypeEx)FrameworkTypeEx.EP_NAME.findExtension(GroovyFrameworkType.class);
    }

    public boolean isEnabledForModuleBuilder(ModuleBuilder builder) {
        return super.isEnabledForModuleBuilder(builder) && !(builder instanceof GroovyAwareModuleBuilder);
    }

    public boolean isSupportAlreadyAdded(Module module, FacetsProvider facetsProvider) {
        String version = GroovyConfigUtils.getInstance().getSDKVersion(module);
        return version != null;
    }

    public FrameworkSupportInModuleConfigurable createConfigurable(FrameworkSupportModel model) {
        return new GroovySupportConfigurable();
    }

    public boolean isEnabledForModuleType(ModuleType moduleType) {
        return GroovyFacetUtil.isAcceptableModuleType(moduleType);
    }
}

