/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;

public class SingleIntegerFieldOptionsPanel
extends JPanel {
    public SingleIntegerFieldOptionsPanel(String labelString, final BaseInspection owner, final String property) {
        super(new GridBagLayout());
        JLabel label = new JLabel(labelString);
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        final JFormattedTextField valueField = new JFormattedTextField(formatter);
        valueField.setValue(this.getPropertyValue(owner, property));
        valueField.setColumns(2);
        Document document = valueField.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            private void textChanged() {
                SingleIntegerFieldOptionsPanel.this.setPropertyValue(owner, property, ((Number)valueField.getValue()).intValue());
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.insets.right = 10;
        constraints.anchor = 512;
        constraints.fill = 0;
        this.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.right = 0;
        constraints.anchor = 512;
        constraints.fill = 0;
        this.add((Component)valueField, constraints);
    }

    private void setPropertyValue(BaseInspection owner, String property, int value) {
        try {
            ((Object)((Object)owner)).getClass().getField(property).setInt((Object)owner, value);
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    private int getPropertyValue(BaseInspection owner, String property) {
        try {
            return ((Object)((Object)owner)).getClass().getField(property).getInt((Object)owner);
        }
        catch (Exception ignore) {
            return 0;
        }
    }
}

