/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleExpression;

public class GroovyStaticTypeCheckVisitor
extends GroovyTypeCheckVisitor {
    private AnnotationHolder myHolder;

    public void setAnnotationHolder(AnnotationHolder annotationHolder) {
        this.myHolder = annotationHolder;
    }

    @Override
    protected void processTupleAssignment(GrTupleExpression tupleExpression, GrExpression initializer) {
        if (initializer instanceof GrListOrMap && !((GrListOrMap)initializer).isMap()) {
            GrExpression[] expressions;
            GrListOrMap initializerList = (GrListOrMap)initializer;
            GrExpression[] vars = tupleExpression.getExpressions();
            if (vars.length > (expressions = initializerList.getInitializers()).length) {
                this.registerError((PsiElement)initializer, GroovyBundle.message("incorrect.number.of.values", vars.length, expressions.length), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR);
            } else {
                for (int i = 0; i < vars.length; ++i) {
                    this.processAssignmentWithinMultipleAssignment(vars[i], expressions[i], tupleExpression);
                }
            }
        } else {
            this.registerError((PsiElement)initializer, GroovyBundle.message("multiple.assignments.without.list.expr", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR);
        }
    }

    @Override
    public void visitAssignmentExpression(GrAssignmentExpression assignment) {
        super.visitAssignmentExpression(assignment);
    }

    @Override
    protected void registerError(final PsiElement location, final String description, final LocalQuickFix[] fixes, final ProblemHighlightType highlightType) {
        if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
            return;
        }
        ArrayList intentions = ContainerUtil.newArrayList();
        if (fixes != null) {
            for (final LocalQuickFix fix : fixes) {
                intentions.add(new IntentionAction(){

                    public String getText() {
                        return fix.getName();
                    }

                    public String getFamilyName() {
                        return fix.getFamilyName();
                    }

                    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
                        return true;
                    }

                    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                        InspectionManager manager = InspectionManager.getInstance((Project)project);
                        ProblemDescriptor descriptor = manager.createProblemDescriptor(location, description, fixes, highlightType, fixes.length == 1, false);
                        fix.applyFix(project, (CommonProblemDescriptor)descriptor);
                    }

                    public boolean startInWriteAction() {
                        return true;
                    }
                });
            }
        }
        this.registerError(location, description, intentions.toArray(new IntentionAction[intentions.size()]), highlightType);
    }

    protected void registerError(PsiElement location, String description, IntentionAction[] fixes, ProblemHighlightType highlightType) {
        if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
            return;
        }
        Annotation annotation = this.myHolder.createErrorAnnotation(location, description);
        if (fixes == null) {
            return;
        }
        for (IntentionAction intention : fixes) {
            annotation.registerFix(intention);
        }
    }

    @Override
    public void visitElement(GroovyPsiElement element) {
    }
}

