/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.ReturnPointCountVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMultipleReturnPointsPerMethodInspectionBase
extends GroovyMethodMetricInspection {
    public String getGroupDisplayName() {
        return "Method Metrics";
    }

    public String getDisplayName() {
        return "Method with multiple return points";
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Return point limit:";
    }

    @Override
    public String buildErrorString(Object ... infos) {
        Integer returnPointCount = (Integer)infos[0];
        return "<code>#ref</code> has " + returnPointCount + " return points #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleReturnPointsVisitor();
    }

    private class MultipleReturnPointsVisitor
    extends BaseInspectionVisitor {
        private MultipleReturnPointsVisitor() {
        }

        @Override
        public void visitMethod(GrMethod method) {
            if (method.getNameIdentifier() == null) {
                return;
            }
            int returnPointCount = this.calculateReturnPointCount(method);
            if (returnPointCount <= GroovyMultipleReturnPointsPerMethodInspectionBase.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, returnPointCount);
        }

        private int calculateReturnPointCount(GrMethod method) {
            ReturnPointCountVisitor visitor = new ReturnPointCountVisitor();
            method.accept(visitor);
            int count = visitor.getCount();
            if (!this.mayFallThroughBottom(method)) {
                return count;
            }
            GrOpenBlock body = method.getBlock();
            if (body == null) {
                return count;
            }
            GrStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return count + 1;
            }
            GrStatement lastStatement = statements[statements.length - 1];
            if (ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                return count + 1;
            }
            return count;
        }

        private boolean mayFallThroughBottom(GrMethod method) {
            if (method.isConstructor()) {
                return true;
            }
            PsiType returnType = method.getReturnType();
            return PsiType.VOID.equals((Object)returnType);
        }
    }
}

