/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

class CyclomaticComplexityVisitor
extends GroovyRecursiveElementVisitor {
    private int complexity = 1;

    CyclomaticComplexityVisitor() {
    }

    @Override
    public void visitElement(GroovyPsiElement GrElement) {
        int oldComplexity = 0;
        if (GrElement instanceof GrMethod) {
            oldComplexity = this.complexity;
        }
        super.visitElement(GrElement);
        if (GrElement instanceof GrMethod) {
            this.complexity = oldComplexity;
        }
    }

    @Override
    public void visitForStatement(GrForStatement statement) {
        super.visitForStatement(statement);
        ++this.complexity;
    }

    @Override
    public void visitIfStatement(GrIfStatement statement) {
        super.visitIfStatement(statement);
        ++this.complexity;
    }

    @Override
    public void visitConditionalExpression(GrConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        ++this.complexity;
    }

    @Override
    public void visitSwitchStatement(GrSwitchStatement statement) {
        GrCaseSection[] caseClauses;
        super.visitSwitchStatement(statement);
        for (GrCaseSection clause : caseClauses = statement.getCaseSections()) {
            GrStatement[] statements = clause.getStatements();
            if (statements == null || statements.length == 0) continue;
            ++this.complexity;
        }
    }

    @Override
    public void visitWhileStatement(GrWhileStatement statement) {
        super.visitWhileStatement(statement);
        ++this.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }
}

