/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;

public class GroovyContinueOrBreakFromFinallyBlockInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Error handling";
    }

    public String getDisplayName() {
        return "'continue' or 'break' inside 'finally' block";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "'#ref' inside 'finally' block #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitContinueStatement(GrContinueStatement continueStatement) {
            super.visitContinueStatement(continueStatement);
            if (!ControlFlowUtils.isInFinallyBlock(continueStatement)) {
                return;
            }
            GrStatement continuedStatement = continueStatement.findTargetStatement();
            if (continuedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(continuedStatement)) {
                return;
            }
            this.registerStatementError(continueStatement, new Object[0]);
        }

        @Override
        public void visitBreakStatement(GrBreakStatement breakStatement) {
            super.visitBreakStatement(breakStatement);
            if (!ControlFlowUtils.isInFinallyBlock(breakStatement)) {
                return;
            }
            GrStatement target = breakStatement.findTargetStatement();
            if (target == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(target)) {
                return;
            }
            this.registerStatementError(breakStatement, new Object[0]);
        }
    }
}

