/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;

public class GroovyBreakInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Control Flow";
    }

    public String getDisplayName() {
        return "Break statement";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "#ref statement #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBreakStatement(GrBreakStatement breakStatement) {
            super.visitBreakStatement(breakStatement);
            GrStatement target = breakStatement.findTargetStatement();
            if (target instanceof GrSwitchStatement) {
                return;
            }
            this.registerError(breakStatement);
        }
    }
}

