/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.confusing.UnnecessaryQualifiedReferenceInspection;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;

public class ReplaceWithImportFix
extends GroovyFix {
    private static final Logger LOG = Logger.getInstance(UnnecessaryQualifiedReferenceInspection.class);

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement startElement = descriptor.getStartElement();
        LOG.assertTrue(startElement instanceof GrReferenceElement);
        GrReferenceAdjuster.shortenReference((GrQualifiedReference)startElement);
    }

    public String getName() {
        return GroovyInspectionBundle.message("replace.qualified.name.with.import", new Object[0]);
    }
}

