/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiNamedElement;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrFieldAlreadyDefinedInspection
extends BaseInspection {
    @Override
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("field.already.defined", args);
    }

    public String getDisplayName() {
        return GroovyInspectionBundle.message("field.already.defined", new Object[0]);
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitField(GrField field) {
            super.visitField(field);
            PsiNamedElement duplicate = ResolveUtil.findDuplicate(field);
            if (duplicate instanceof GrField) {
                this.registerError(field.getNameIdentifierGroovy(), field.getName());
            }
        }
    }
}

