/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyResultOfAssignmentUsedInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Assignment issues";
    }

    public String getDisplayName() {
        return "Result of assignment used";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Result of assignment expression used #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression grAssignmentExpression) {
            super.visitAssignmentExpression(grAssignmentExpression);
            if (PsiUtil.isExpressionUsed(grAssignmentExpression)) {
                this.registerError(grAssignmentExpression);
            }
        }
    }
}

