/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;

public class GroovyNestedAssignmentInspection
extends BaseInspection {
    public String getGroupDisplayName() {
        return "Assignment issues";
    }

    public String getDisplayName() {
        return "Nested assignment";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Nested assignment expression #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression grAssignmentExpression) {
            super.visitAssignmentExpression(grAssignmentExpression);
            PsiElement parent = grAssignmentExpression.getParent();
            if (!(parent instanceof GrAssignmentExpression)) {
                return;
            }
            this.registerError(grAssignmentExpression);
        }
    }
}

