/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrBinaryExprInfo
implements CallInfo<GrBinaryExpression> {
    private final GrBinaryExpression myExpr;

    public GrBinaryExprInfo(GrBinaryExpression expr) {
        this.myExpr = expr;
    }

    @Override
    public GrArgumentList getArgumentList() {
        return null;
    }

    @Override
    public PsiType[] getArgumentTypes() {
        GrExpression operand = this.myExpr.getRightOperand();
        return new PsiType[]{operand != null ? operand.getType() : null};
    }

    @Override
    public GrExpression getInvokedExpression() {
        return this.myExpr.getLeftOperand();
    }

    @Override
    public PsiType getQualifierInstanceType() {
        return this.myExpr.getLeftOperand().getType();
    }

    @Override
    public PsiElement getHighlightElementForCategoryQualifier() {
        return this.myExpr.getOperationToken();
    }

    @Override
    public PsiElement getElementToHighlight() {
        return this.myExpr.getOperationToken();
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        return PsiImplUtil.extractUniqueResult(this.multiResolve());
    }

    @Override
    public GroovyResolveResult[] multiResolve() {
        return this.myExpr.multiResolve(false);
    }

    @Override
    public GrBinaryExpression getCall() {
        return this.myExpr;
    }

    @Override
    public GrExpression[] getExpressionArguments() {
        GrExpression right = this.myExpr.getRightOperand();
        if (right != null) {
            return new GrExpression[]{right};
        }
        return GrExpression.EMPTY_ARRAY;
    }

    @Override
    public GrClosableBlock[] getClosureArguments() {
        return GrClosableBlock.EMPTY_ARRAY;
    }

    @Override
    public GrNamedArgument[] getNamedArguments() {
        return GrNamedArgument.EMPTY_ARRAY;
    }
}

