/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class CustomAnnotationChecker {
    public static final ExtensionPointName<CustomAnnotationChecker> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.customAnnotationChecker");

    public boolean checkArgumentList(AnnotationHolder holder, GrAnnotation annotation) {
        return false;
    }

    public boolean checkApplicability(AnnotationHolder holder, GrAnnotation annotation) {
        return false;
    }

    public static String isAnnotationApplicable(GrAnnotation annotation, PsiAnnotationOwner owner) {
        if (!(owner instanceof PsiElement)) {
            return null;
        }
        PsiElement ownerToUse = owner instanceof PsiModifierList ? ((PsiElement)owner).getParent() : (PsiElement)owner;
        PsiAnnotation.TargetType[] elementTypeFields = GrAnnotationImpl.getApplicableElementTypeFields(ownerToUse);
        if (elementTypeFields.length != 0 && !GrAnnotationImpl.isAnnotationApplicableTo(annotation, elementTypeFields)) {
            String annotationTargetText = JavaErrorMessages.message((String)("annotation.target." + elementTypeFields[0]), (Object[])new Object[0]);
            GrCodeReferenceElement ref = annotation.getClassReference();
            return JavaErrorMessages.message((String)"annotation.not.applicable", (Object[])new Object[]{ref.getText(), annotationTargetText});
        }
        return null;
    }

    public static void checkAnnotationArguments(AnnotationHolder holder, PsiClass annotation, GrCodeReferenceElement refToHighlight, GrAnnotationNameValuePair[] attributes, boolean checkMissedAttributes) {
        PsiMethod[] methods;
        HashSet usedAttrs = new HashSet();
        if (attributes.length > 0) {
            PsiElement identifier = attributes[0].getNameIdentifierGroovy();
            if (attributes.length == 1 && identifier == null) {
                CustomAnnotationChecker.checkAnnotationValue(annotation, attributes[0], "value", (Set<String>)usedAttrs, attributes[0].getValue(), holder);
            } else {
                for (GrAnnotationNameValuePair attribute : attributes) {
                    String name = attribute.getName();
                    if (name == null) continue;
                    PsiElement toHighlight = attribute.getNameIdentifierGroovy();
                    assert (toHighlight != null);
                    CustomAnnotationChecker.checkAnnotationValue(annotation, toHighlight, name, (Set<String>)usedAttrs, attribute.getValue(), holder);
                }
            }
        }
        ArrayList<String> missedAttrs = new ArrayList<String>();
        for (PsiMethod method : methods = annotation.getMethods()) {
            String name = method.getName();
            if (usedAttrs.contains(name) || method instanceof PsiAnnotationMethod && ((PsiAnnotationMethod)method).getDefaultValue() != null) continue;
            missedAttrs.add(name);
        }
        if (checkMissedAttributes && !missedAttrs.isEmpty()) {
            holder.createErrorAnnotation((PsiElement)refToHighlight, GroovyBundle.message("missed.attributes", StringUtil.join(missedAttrs, (String)", ")));
        }
    }

    private static void checkAnnotationValue(PsiClass annotation, PsiElement identifierToHighlight, String name, Set<String> usedAttrs, GrAnnotationMemberValue value, AnnotationHolder holder) {
        if (usedAttrs.contains(name)) {
            holder.createErrorAnnotation(identifierToHighlight, GroovyBundle.message("duplicate.attribute", new Object[0]));
        }
        usedAttrs.add(name);
        PsiMethod[] methods = annotation.findMethodsByName(name, false);
        if (methods.length == 0) {
            holder.createErrorAnnotation(identifierToHighlight, GroovyBundle.message("at.interface.0.does.not.contain.attribute", annotation.getQualifiedName(), name));
        } else {
            PsiMethod method = methods[0];
            PsiType ltype = method.getReturnType();
            if (ltype != null && value != null) {
                CustomAnnotationChecker.checkAnnotationValueByType(holder, value, ltype, true);
            }
        }
    }

    public static void checkAnnotationValueByType(AnnotationHolder holder, GrAnnotationMemberValue value, PsiType ltype, boolean skipArrays) {
        GlobalSearchScope resolveScope = value.getResolveScope();
        PsiManager manager = value.getManager();
        if (value instanceof GrExpression) {
            Object rtype = value instanceof GrClosableBlock ? PsiType.getJavaLangClass((PsiManager)manager, (GlobalSearchScope)resolveScope) : ((GrExpression)value).getType();
            if (rtype != null && !CustomAnnotationChecker.checkAnnoTypeAssignable(ltype, (PsiType)rtype, value, skipArrays)) {
                holder.createErrorAnnotation((PsiElement)value, GroovyBundle.message("cannot.assign", rtype.getPresentableText(), ltype.getPresentableText()));
            }
        } else if (value instanceof GrAnnotation) {
            PsiClassType rtype;
            PsiElement resolved = ((GrAnnotation)value).getClassReference().resolve();
            if (resolved instanceof PsiClass && !CustomAnnotationChecker.checkAnnoTypeAssignable(ltype, (PsiType)(rtype = JavaPsiFacade.getElementFactory((Project)value.getProject()).createType((PsiClass)resolved, PsiSubstitutor.EMPTY)), value, skipArrays)) {
                holder.createErrorAnnotation((PsiElement)value, GroovyBundle.message("cannot.assign", rtype.getPresentableText(), ltype.getPresentableText()));
            }
        } else if (value instanceof GrAnnotationArrayInitializer) {
            if (ltype instanceof PsiArrayType) {
                GrAnnotationMemberValue[] initializers;
                PsiType componentType = ((PsiArrayType)ltype).getComponentType();
                for (GrAnnotationMemberValue initializer : initializers = ((GrAnnotationArrayInitializer)value).getInitializers()) {
                    CustomAnnotationChecker.checkAnnotationValueByType(holder, initializer, componentType, false);
                }
            } else {
                PsiType rtype = TypesUtil.getTupleByAnnotationArrayInitializer((GrAnnotationArrayInitializer)value);
                if (!CustomAnnotationChecker.checkAnnoTypeAssignable(ltype, rtype, value, skipArrays)) {
                    holder.createErrorAnnotation((PsiElement)value, GroovyBundle.message("cannot.assign", rtype.getPresentableText(), ltype.getPresentableText()));
                }
            }
        }
    }

    private static boolean checkAnnoTypeAssignable(PsiType type, PsiType rtype, GroovyPsiElement context, boolean skipArrays) {
        if (TypesUtil.isAssignableByMethodCallConversion(type, rtype = TypesUtil.unboxPrimitiveTypeWrapper(rtype), context)) {
            return true;
        }
        if (!(type instanceof PsiArrayType) || !skipArrays) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        return CustomAnnotationChecker.checkAnnoTypeAssignable(componentType, rtype, context, skipArrays);
    }

    public static void highlightErrors(AnnotationHolder holder, Map<PsiElement, String> errors) {
        for (Map.Entry<PsiElement, String> entry : errors.entrySet()) {
            holder.createErrorAnnotation(entry.getKey(), entry.getValue());
        }
    }
}

